/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util.collections.binary;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentSource;
import org.apache.flink.runtime.io.disk.RandomAccessInputView;
import org.apache.flink.runtime.io.disk.SimpleCollectingOutputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.PagedTypeSerializer;
import org.apache.flink.table.runtime.util.KeyValueIterator;
import org.apache.flink.table.runtime.util.collections.binary.AbstractBytesMultiMap;
import org.apache.flink.table.runtime.util.collections.binary.BytesMap;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBytesMultiMap<K>
extends BytesMap<K, Iterator<RowData>> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBytesMultiMap.class);
    protected final PagedTypeSerializer<K> keySerializer;
    private final BinaryRowDataSerializer valueSerializer;
    private int endPtr;
    private int endPtrOffset;
    private int pointerToSecondValue;
    private BinaryRowData reusedRecord;
    private long numKeys = 0L;

    public AbstractBytesMultiMap(Object owner, MemoryManager memoryManager, long memorySize, PagedTypeSerializer<K> keySerializer, LogicalType[] valueTypes) {
        this(owner, memoryManager, memorySize, keySerializer, valueTypes.length);
    }

    public AbstractBytesMultiMap(Object owner, MemoryManager memoryManager, long memorySize, PagedTypeSerializer<K> keySerializer, int valueArity) {
        super(owner, memoryManager, memorySize, keySerializer);
        Preconditions.checkArgument((valueArity > 0 ? 1 : 0) != 0);
        this.recordArea = new RecordArea();
        this.keySerializer = keySerializer;
        this.valueSerializer = new BinaryRowDataSerializer(valueArity);
        this.reusedValue = ((RecordArea)this.recordArea).valueIterator(-1);
        this.reusedRecord = this.valueSerializer.createInstance();
        Preconditions.checkArgument((memorySize > 0x100000L ? 1 : 0) != 0, (Object)"The minBucketMemorySize is not valid!");
        int initBucketSegmentNum = MathUtils.roundDownToPowerOf2((int)((int)(0x100000L / (long)this.segmentSize)));
        this.initBucketSegments(initBucketSegmentNum);
        LOG.info("BytesMultiMap with initial memory segments {}, {} in bytes, init allocating {} for bucket area.", new Object[]{this.reservedNumBuffers, this.reservedNumBuffers * this.segmentSize, initBucketSegmentNum});
    }

    @Override
    public long getNumKeys() {
        return this.numKeys;
    }

    public void append(BytesMap.LookupInfo<K, Iterator<RowData>> lookupInfo, BinaryRowData value) throws IOException {
        try {
            if (lookupInfo.found) {
                int newPointer = ((RecordArea)this.recordArea).appendValue(value);
                if (this.pointerToSecondValue == -1) {
                    ((RecordArea)this.recordArea).updateValuePointerInKeyArea(newPointer, this.endPtr);
                } else {
                    ((RecordArea)this.recordArea).updateValuePointerInValueArea(newPointer, this.endPtr);
                }
                this.endPtr = newPointer;
                ((RecordArea)this.recordArea).updateValuePointerInKeyArea(newPointer, this.endPtrOffset);
            } else {
                if (this.numKeys >= (long)this.growthThreshold) {
                    this.growAndRehash();
                    this.lookup(lookupInfo.key);
                }
                int pointerToAppended = this.recordArea.appendRecord(lookupInfo, value);
                ((MemorySegment)this.bucketSegments.get(lookupInfo.bucketSegmentIndex)).putInt(lookupInfo.bucketOffset, pointerToAppended);
                ((MemorySegment)this.bucketSegments.get(lookupInfo.bucketSegmentIndex)).putInt(lookupInfo.bucketOffset + 4, lookupInfo.keyHashCode);
                ++this.numKeys;
            }
            ++this.numElements;
        }
        catch (EOFException e) {
            ++this.numSpillFiles;
            this.spillInBytes += this.recordArea.getSegmentsSize();
            throw e;
        }
    }

    public KeyValueIterator<K, Iterator<RowData>> getEntryIterator(boolean requiresCopy) {
        return ((RecordArea)this.recordArea).entryIterator(requiresCopy);
    }

    public void free() {
        this.free(false);
    }

    @Override
    public void free(boolean reservedFixedMemory) {
        this.recordArea.release();
        this.numKeys = 0L;
        super.free(reservedFixedMemory);
    }

    @Override
    public void reset() {
        super.reset();
        this.recordArea.reset();
        this.numKeys = 0L;
    }

    private long writePointer(SimpleCollectingOutputView outputView, int value) throws IOException {
        int oldPosition = (int)outputView.getCurrentOffset();
        int skip = this.checkSkipWriteForPointer((AbstractPagedOutputView)outputView);
        outputView.getCurrentSegment().putInt(outputView.getCurrentPositionInSegment(), value);
        outputView.skipBytesToWrite(4);
        return oldPosition + skip;
    }

    private int readPointer(AbstractPagedInputView inputView) throws IOException {
        this.checkSkipReadForPointer(inputView);
        int value = inputView.getCurrentSegment().getInt(inputView.getCurrentPositionInSegment());
        inputView.skipBytesToRead(4);
        return value;
    }

    private int skipPointer(SimpleCollectingOutputView outputView) throws IOException {
        int oldPosition = (int)outputView.getCurrentOffset();
        int skip = this.checkSkipWriteForPointer((AbstractPagedOutputView)outputView);
        outputView.skipBytesToWrite(4);
        return oldPosition + skip;
    }

    private void skipPointer(AbstractPagedInputView inputView) throws IOException {
        this.checkSkipReadForPointer(inputView);
        inputView.skipBytesToRead(4);
    }

    private int checkSkipWriteForPointer(AbstractPagedOutputView outView) throws IOException {
        int available = outView.getSegmentSize() - outView.getCurrentPositionInSegment();
        if (available < 4) {
            outView.advance();
            return available;
        }
        return 0;
    }

    private void checkSkipReadForPointer(AbstractPagedInputView source) throws IOException {
        int available = source.getCurrentSegmentLimit() - source.getCurrentPositionInSegment();
        if (available < 4) {
            source.advance();
        }
    }

    private final class RecordArea
    implements BytesMap.RecordArea<K, Iterator<RowData>> {
        private final ArrayList<MemorySegment> keySegments = new ArrayList();
        private final ArrayList<MemorySegment> valSegments = new ArrayList();
        private final RandomAccessInputView keyInView;
        private final RandomAccessInputView valInView;
        private final SimpleCollectingOutputView keyOutView;
        private final SimpleCollectingOutputView valOutView;
        private org.apache.flink.table.runtime.util.collections.binary.AbstractBytesMultiMap$RecordArea.ValueIterator reusedValueIterator = new ValueIterator(0);

        RecordArea() {
            this.keyOutView = new SimpleCollectingOutputView(this.keySegments, (MemorySegmentSource)AbstractBytesMultiMap.this.memoryPool, AbstractBytesMultiMap.this.segmentSize);
            this.valOutView = new SimpleCollectingOutputView(this.valSegments, (MemorySegmentSource)AbstractBytesMultiMap.this.memoryPool, AbstractBytesMultiMap.this.segmentSize);
            this.keyInView = new RandomAccessInputView(this.keySegments, AbstractBytesMultiMap.this.segmentSize);
            this.valInView = new RandomAccessInputView(this.valSegments, AbstractBytesMultiMap.this.segmentSize);
        }

        @Override
        public void release() {
            AbstractBytesMultiMap.this.returnSegments(this.valSegments);
            AbstractBytesMultiMap.this.returnSegments(this.keySegments);
            this.valSegments.clear();
            this.keySegments.clear();
        }

        @Override
        public void reset() {
            this.release();
            this.keyOutView.reset();
            this.valOutView.reset();
            this.valInView.setReadPosition(0L);
            this.keyInView.setReadPosition(0L);
        }

        private int appendValue(BinaryRowData value) throws IOException {
            long offsetOfPointer = AbstractBytesMultiMap.this.writePointer(this.valOutView, -1);
            AbstractBytesMultiMap.this.valueSerializer.serializeToPages(value, (AbstractPagedOutputView)this.valOutView);
            if (offsetOfPointer > Integer.MAX_VALUE) {
                LOG.warn("We can't handle key area with more than Integer.MAX_VALUE bytes, because the pointer is a integer.");
                throw new EOFException();
            }
            return (int)offsetOfPointer;
        }

        @Override
        public void setReadPosition(int position) {
            this.keyInView.setReadPosition((long)position);
        }

        @Override
        public boolean readKeyAndEquals(K lookupKey) throws IOException {
            AbstractBytesMultiMap.this.reusedKey = AbstractBytesMultiMap.this.keySerializer.mapFromPages(AbstractBytesMultiMap.this.reusedKey, (AbstractPagedInputView)this.keyInView);
            return lookupKey.equals(AbstractBytesMultiMap.this.reusedKey);
        }

        @Override
        public Iterator<RowData> readValue(Iterator<RowData> reuse) throws IOException {
            AbstractBytesMultiMap.this.endPtr = AbstractBytesMultiMap.this.readPointer((AbstractPagedInputView)this.keyInView);
            AbstractBytesMultiMap.this.endPtrOffset = (int)this.keyInView.getReadPosition() - 4;
            AbstractBytesMultiMap.this.pointerToSecondValue = AbstractBytesMultiMap.this.readPointer((AbstractPagedInputView)this.keyInView);
            return reuse;
        }

        @Override
        public int appendRecord(BytesMap.LookupInfo<K, Iterator<RowData>> lookupInfo, BinaryRowData value) throws IOException {
            int lastPosition = (int)this.keyOutView.getCurrentOffset();
            int skip = AbstractBytesMultiMap.this.keySerializer.serializeToPages(lookupInfo.key, (AbstractPagedOutputView)this.keyOutView);
            int keyOffset = lastPosition + skip;
            AbstractBytesMultiMap.this.endPtrOffset = AbstractBytesMultiMap.this.skipPointer(this.keyOutView);
            long pointerOfEndValue = AbstractBytesMultiMap.this.writePointer(this.keyOutView, -1);
            AbstractBytesMultiMap.this.valueSerializer.serializeToPages(value, (AbstractPagedOutputView)this.keyOutView);
            if (pointerOfEndValue > Integer.MAX_VALUE) {
                LOG.warn("We can't handle key area with more than Integer.MAX_VALUE bytes, because the pointer is a integer.");
                throw new EOFException();
            }
            AbstractBytesMultiMap.this.endPtr = (int)pointerOfEndValue;
            this.updateValuePointerInKeyArea(AbstractBytesMultiMap.this.endPtr, AbstractBytesMultiMap.this.endPtrOffset);
            return keyOffset;
        }

        @Override
        public long getSegmentsSize() {
            return (long)(this.valSegments.size() + this.keySegments.size()) * (long)AbstractBytesMultiMap.this.segmentSize;
        }

        void updateValuePointerInKeyArea(int newPointer, int ptrOffset) throws IOException {
            this.updateValuePointer(this.keyInView, newPointer, ptrOffset);
        }

        void updateValuePointerInValueArea(int newPointer, int ptrOffset) throws IOException {
            this.updateValuePointer(this.valInView, newPointer, ptrOffset);
        }

        private void updateValuePointer(RandomAccessInputView view, int newPointer, int ptrOffset) throws IOException {
            view.setReadPosition((long)ptrOffset);
            int currPosInSeg = view.getCurrentPositionInSegment();
            view.getCurrentSegment().putInt(currPosInSeg, newPointer);
        }

        KeyValueIterator<K, Iterator<RowData>> entryIterator(boolean requiresCopy) {
            return new EntryIterator(requiresCopy);
        }

        Iterator<RowData> valueIterator(int valueOffset) {
            this.reusedValueIterator.setOffset(valueOffset);
            return this.reusedValueIterator;
        }

        final class ValueIterator
        implements Iterator<RowData> {
            private int offset;
            private boolean isFirstRead;
            private boolean requiresCopy;

            public ValueIterator(int offset) {
                this.offset = offset;
                this.isFirstRead = true;
                this.requiresCopy = false;
            }

            public void setOffset(int offset) {
                this.offset = offset;
                this.isFirstRead = true;
            }

            public void setRequiresCopy(boolean requiresCopy) {
                this.requiresCopy = requiresCopy;
            }

            @Override
            public boolean hasNext() {
                return this.isFirstRead || this.offset != -1;
            }

            @Override
            public RowData next() {
                if (this.isFirstRead) {
                    this.isFirstRead = false;
                    return this.requiresCopy ? AbstractBytesMultiMap.this.reusedRecord.copy() : AbstractBytesMultiMap.this.reusedRecord;
                }
                if (this.hasNext()) {
                    RecordArea.this.valInView.setReadPosition((long)this.offset);
                    try {
                        this.offset = AbstractBytesMultiMap.this.readPointer((AbstractPagedInputView)RecordArea.this.valInView);
                        AbstractBytesMultiMap.this.valueSerializer.mapFromPages(AbstractBytesMultiMap.this.reusedRecord, (AbstractPagedInputView)RecordArea.this.valInView);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Exception happened while iterating value list of a key in BytesMultiMap");
                    }
                    return this.requiresCopy ? AbstractBytesMultiMap.this.reusedRecord.copy() : AbstractBytesMultiMap.this.reusedRecord;
                }
                return null;
            }
        }

        final class EntryIterator
        implements KeyValueIterator<K, Iterator<RowData>> {
            private int count;
            private final boolean requiresCopy;

            public EntryIterator(boolean requiresCopy) {
                this.requiresCopy = requiresCopy;
                RecordArea.this.reusedValueIterator.setRequiresCopy(requiresCopy);
                this.count = 0;
                if (AbstractBytesMultiMap.this.numKeys > 0L) {
                    AbstractBytesMultiMap.this.recordArea.setReadPosition(0);
                }
            }

            @Override
            public boolean advanceNext() throws IOException {
                if ((long)this.count < AbstractBytesMultiMap.this.numKeys) {
                    ++this.count;
                    AbstractBytesMultiMap.this.keySerializer.mapFromPages(AbstractBytesMultiMap.this.reusedKey, (AbstractPagedInputView)RecordArea.this.keyInView);
                    AbstractBytesMultiMap.this.skipPointer((AbstractPagedInputView)RecordArea.this.keyInView);
                    AbstractBytesMultiMap.this.pointerToSecondValue = AbstractBytesMultiMap.this.readPointer((AbstractPagedInputView)RecordArea.this.keyInView);
                    AbstractBytesMultiMap.this.reusedRecord = AbstractBytesMultiMap.this.valueSerializer.mapFromPages(AbstractBytesMultiMap.this.reusedRecord, (AbstractPagedInputView)RecordArea.this.keyInView);
                    RecordArea.this.reusedValueIterator.setOffset(AbstractBytesMultiMap.this.pointerToSecondValue);
                    return true;
                }
                return false;
            }

            @Override
            public K getKey() {
                return this.requiresCopy ? AbstractBytesMultiMap.this.keySerializer.copy(AbstractBytesMultiMap.this.reusedKey) : AbstractBytesMultiMap.this.reusedKey;
            }

            @Override
            public Iterator<RowData> getValue() {
                return (Iterator)AbstractBytesMultiMap.this.reusedValue;
            }

            public boolean hasNext() {
                return (long)this.count < AbstractBytesMultiMap.this.numKeys;
            }
        }
    }
}

