/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.window.processors;

import java.time.ZoneId;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.operators.aggregate.window.buffers.WindowBuffer;
import org.apache.flink.table.runtime.operators.aggregate.window.processors.AbstractWindowAggProcessor;
import org.apache.flink.table.runtime.operators.window.slicing.SliceUnsharedAssigner;

public final class SliceUnsharedWindowAggProcessor
extends AbstractWindowAggProcessor {
    private static final long serialVersionUID = 1L;

    public SliceUnsharedWindowAggProcessor(GeneratedNamespaceAggsHandleFunction<Long> genAggsHandler, WindowBuffer.Factory windowBufferFactory, SliceUnsharedAssigner sliceAssigner, TypeSerializer<RowData> accSerializer, ZoneId shiftTimeZone) {
        super(genAggsHandler, windowBufferFactory, sliceAssigner, accSerializer, shiftTimeZone);
    }

    @Override
    public void fireWindow(Long windowEnd) throws Exception {
        RowData acc = this.windowState.value(windowEnd);
        if (acc == null) {
            acc = this.aggregator.createAccumulators();
        }
        this.aggregator.setAccumulators(windowEnd, acc);
        RowData aggResult = this.aggregator.getValue(windowEnd);
        this.collect(aggResult);
    }

    @Override
    protected long sliceStateMergeTarget(long sliceToMerge) throws Exception {
        return sliceToMerge;
    }
}

