/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class MapType
extends LogicalType {
    public static final String FORMAT = "MAP<%s, %s>";
    private static final Set<String> INPUT_OUTPUT_CONVERSION = MapType.conversionSet(Map.class.getName(), MapData.class.getName());
    private static final Class<?> DEFAULT_CONVERSION = Map.class;
    private final LogicalType keyType;
    private final LogicalType valueType;

    public MapType(boolean isNullable, LogicalType keyType, LogicalType valueType) {
        super(isNullable, LogicalTypeRoot.MAP);
        this.keyType = (LogicalType)Preconditions.checkNotNull((Object)keyType, (String)"Key type must not be null.");
        this.valueType = (LogicalType)Preconditions.checkNotNull((Object)valueType, (String)"Value type must not be null.");
    }

    public MapType(LogicalType keyType, LogicalType valueType) {
        this(true, keyType, valueType);
    }

    public LogicalType getKeyType() {
        return this.keyType;
    }

    public LogicalType getValueType() {
        return this.valueType;
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new MapType(isNullable, this.keyType.copy(), this.valueType.copy());
    }

    @Override
    public String asSummaryString() {
        return this.withNullability(FORMAT, this.keyType.asSummaryString(), this.valueType.asSummaryString());
    }

    @Override
    public String asSerializableString() {
        return this.withNullability(FORMAT, this.keyType.asSerializableString(), this.valueType.asSerializableString());
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        if (Map.class.isAssignableFrom(clazz)) {
            return true;
        }
        return INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        return INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public Class<?> getDefaultConversion() {
        return DEFAULT_CONVERSION;
    }

    @Override
    public List<LogicalType> getChildren() {
        return Collections.unmodifiableList(Arrays.asList(this.keyType, this.valueType));
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MapType mapType = (MapType)o;
        return this.keyType.equals(mapType.keyType) && this.valueType.equals(mapType.valueType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.keyType, this.valueType);
    }
}

