/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.RunnableFuture;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.CheckpointListener;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.contrib.streaming.state.EmbeddedRocksDBStateBackend;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackendBuilder;
import org.apache.flink.contrib.streaming.state.RocksDBOperationUtils;
import org.apache.flink.contrib.streaming.state.RocksDBOptions;
import org.apache.flink.contrib.streaming.state.RocksDBResourceContainer;
import org.apache.flink.contrib.streaming.state.RocksDBStateUploader;
import org.apache.flink.contrib.streaming.state.RocksDBTestUtils;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.CheckpointableKeyedStateBackend;
import org.apache.flink.runtime.state.ConfigurableStateBackend;
import org.apache.flink.runtime.state.IncrementalKeyedStateHandle;
import org.apache.flink.runtime.state.IncrementalRemoteKeyedStateHandle;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryImpl;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.StateBackendTestBase;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.runtime.state.storage.FileSystemCheckpointStorage;
import org.apache.flink.runtime.state.storage.JobManagerCheckpointStorage;
import org.apache.flink.runtime.util.BlockerCheckpointStreamFactory;
import org.apache.flink.runtime.util.BlockingCheckpointOutputStream;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.function.SupplierWithException;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.RocksObject;
import org.rocksdb.Snapshot;

@RunWith(value=Parameterized.class)
public class EmbeddedRocksDBStateBackendTest
extends StateBackendTestBase<EmbeddedRocksDBStateBackend> {
    private OneShotLatch blocker;
    private OneShotLatch waiter;
    private BlockerCheckpointStreamFactory testStreamFactory;
    private RocksDBKeyedStateBackend<Integer> keyedStateBackend;
    private List<RocksObject> allCreatedCloseables;
    private ValueState<Integer> testState1;
    private ValueState<String> testState2;
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER = new TemporaryFolder();
    @Parameterized.Parameter(value=0)
    public boolean enableIncrementalCheckpointing;
    @Parameterized.Parameter(value=1)
    public SupplierWithException<CheckpointStorage, IOException> storageSupplier;
    private String dbPath;
    private RocksDB db = null;
    private ColumnFamilyHandle defaultCFHandle = null;
    private RocksDBStateUploader rocksDBStateUploader = null;
    private final RocksDBResourceContainer optionsContainer = new RocksDBResourceContainer();

    @Parameterized.Parameters
    public static List<Object[]> modes() {
        return Arrays.asList({true, JobManagerCheckpointStorage::new}, {false, () -> {
            String checkpointPath = TEMP_FOLDER.newFolder().toURI().toString();
            return new FileSystemCheckpointStorage(new Path(checkpointPath), 0, -1);
        }});
    }

    public void prepareRocksDB() throws Exception {
        String dbPath = RocksDBKeyedStateBackendBuilder.getInstanceRocksDBPath((File)TEMP_FOLDER.newFolder()).getAbsolutePath();
        ColumnFamilyOptions columnOptions = this.optionsContainer.getColumnOptions();
        ArrayList columnFamilyHandles = new ArrayList(1);
        this.db = RocksDBOperationUtils.openDB((String)dbPath, Collections.emptyList(), columnFamilyHandles, (ColumnFamilyOptions)columnOptions, (DBOptions)this.optionsContainer.getDbOptions());
        this.defaultCFHandle = (ColumnFamilyHandle)columnFamilyHandles.remove(0);
    }

    protected ConfigurableStateBackend getStateBackend() throws IOException {
        this.dbPath = TEMP_FOLDER.newFolder().getAbsolutePath();
        EmbeddedRocksDBStateBackend backend = new EmbeddedRocksDBStateBackend(this.enableIncrementalCheckpointing);
        Configuration configuration = new Configuration();
        configuration.set(RocksDBOptions.TIMER_SERVICE_FACTORY, (Object)EmbeddedRocksDBStateBackend.PriorityQueueStateType.ROCKSDB);
        backend = backend.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        backend.setDbStoragePath(this.dbPath);
        return backend;
    }

    protected CheckpointStorage getCheckpointStorage() throws Exception {
        return (CheckpointStorage)this.storageSupplier.get();
    }

    protected boolean isSerializerPresenceRequiredOnRestore() {
        return false;
    }

    protected boolean supportsAsynchronousSnapshots() {
        return true;
    }

    protected boolean isSafeToReuseKVState() {
        return true;
    }

    @After
    public void cleanupRocksDB() {
        if (this.keyedStateBackend != null) {
            IOUtils.closeQuietly(this.keyedStateBackend);
            this.keyedStateBackend.dispose();
        }
        IOUtils.closeQuietly((AutoCloseable)this.defaultCFHandle);
        IOUtils.closeQuietly((AutoCloseable)this.db);
        IOUtils.closeQuietly((AutoCloseable)this.optionsContainer);
        if (this.allCreatedCloseables != null) {
            for (RocksObject rocksCloseable : this.allCreatedCloseables) {
                ((RocksObject)Mockito.verify((Object)rocksCloseable, (VerificationMode)VerificationModeFactory.times((int)1))).close();
            }
            this.allCreatedCloseables = null;
        }
    }

    public void setupRocksKeyedStateBackend() throws Exception {
        this.blocker = new OneShotLatch();
        this.waiter = new OneShotLatch();
        this.testStreamFactory = new BlockerCheckpointStreamFactory(0x100000);
        this.testStreamFactory.setBlockerLatch(this.blocker);
        this.testStreamFactory.setWaiterLatch(this.waiter);
        this.testStreamFactory.setAfterNumberInvocations(10);
        this.prepareRocksDB();
        RocksDBKeyedStateBackendBuilder keyedStateBackendBuilder = RocksDBTestUtils.builderForTestDB(TEMP_FOLDER.newFolder(), IntSerializer.INSTANCE, (RocksDB)Mockito.spy((Object)this.db), this.defaultCFHandle, this.optionsContainer.getColumnOptions()).setEnableIncrementalCheckpointing(this.enableIncrementalCheckpointing);
        if (this.enableIncrementalCheckpointing) {
            this.rocksDBStateUploader = (RocksDBStateUploader)Mockito.spy((Object)new RocksDBStateUploader(((Integer)RocksDBOptions.CHECKPOINT_TRANSFER_THREAD_NUM.defaultValue()).intValue()));
            keyedStateBackendBuilder.setRocksDBStateUploader(this.rocksDBStateUploader);
        }
        this.keyedStateBackend = keyedStateBackendBuilder.build();
        this.testState1 = (ValueState)this.keyedStateBackend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, (StateDescriptor)new ValueStateDescriptor("TestState-1", Integer.class, (Object)0));
        this.testState2 = (ValueState)this.keyedStateBackend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, (StateDescriptor)new ValueStateDescriptor("TestState-2", String.class, (Object)""));
        this.allCreatedCloseables = new ArrayList<RocksObject>();
        ((RocksDB)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                RocksIterator rocksIterator = (RocksIterator)Mockito.spy((Object)((RocksIterator)invocationOnMock.callRealMethod()));
                EmbeddedRocksDBStateBackendTest.this.allCreatedCloseables.add(rocksIterator);
                return rocksIterator;
            }
        }).when((Object)this.keyedStateBackend.db)).newIterator((ColumnFamilyHandle)Matchers.any(ColumnFamilyHandle.class), (ReadOptions)Matchers.any(ReadOptions.class));
        ((RocksDB)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                Snapshot snapshot = (Snapshot)Mockito.spy((Object)((Snapshot)invocationOnMock.callRealMethod()));
                EmbeddedRocksDBStateBackendTest.this.allCreatedCloseables.add(snapshot);
                return snapshot;
            }
        }).when((Object)this.keyedStateBackend.db)).getSnapshot();
        ((RocksDB)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                ColumnFamilyHandle snapshot = (ColumnFamilyHandle)Mockito.spy((Object)((ColumnFamilyHandle)invocationOnMock.callRealMethod()));
                EmbeddedRocksDBStateBackendTest.this.allCreatedCloseables.add(snapshot);
                return snapshot;
            }
        }).when((Object)this.keyedStateBackend.db)).createColumnFamily((ColumnFamilyDescriptor)Matchers.any(ColumnFamilyDescriptor.class));
        for (int i = 0; i < 100; ++i) {
            this.keyedStateBackend.setCurrentKey((Object)i);
            this.testState1.update((Object)(4200 + i));
            this.testState2.update((Object)("S-" + (4200 + i)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testCorrectMergeOperatorSet() throws Exception {
        ColumnFamilyOptions columnFamilyOptions;
        block3: {
            this.prepareRocksDB();
            columnFamilyOptions = (ColumnFamilyOptions)Mockito.spy((Object)new ColumnFamilyOptions());
            RocksDBKeyedStateBackend test = null;
            try {
                test = RocksDBTestUtils.builderForTestDB(TEMP_FOLDER.newFolder(), IntSerializer.INSTANCE, this.db, this.defaultCFHandle, columnFamilyOptions).setEnableIncrementalCheckpointing(this.enableIncrementalCheckpointing).build();
                ValueStateDescriptor stubState1 = new ValueStateDescriptor("StubState-1", (TypeSerializer)StringSerializer.INSTANCE);
                test.createOrUpdateInternalState((TypeSerializer)StringSerializer.INSTANCE, (StateDescriptor)stubState1);
                ValueStateDescriptor stubState2 = new ValueStateDescriptor("StubState-2", (TypeSerializer)StringSerializer.INSTANCE);
                test.createOrUpdateInternalState((TypeSerializer)StringSerializer.INSTANCE, (StateDescriptor)stubState2);
                ((ColumnFamilyOptions)Mockito.verify((Object)columnFamilyOptions, (VerificationMode)Mockito.times((int)2))).setMergeOperatorName("stringappendtest");
                if (test == null) break block3;
            }
            catch (Throwable throwable) {
                if (test != null) {
                    IOUtils.closeQuietly(test);
                    test.dispose();
                }
                columnFamilyOptions.close();
                throw throwable;
            }
            IOUtils.closeQuietly((AutoCloseable)test);
            test.dispose();
        }
        columnFamilyOptions.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReleasingSnapshotAfterBackendClosed() throws Exception {
        this.setupRocksKeyedStateBackend();
        try {
            RunnableFuture snapshot = this.keyedStateBackend.snapshot(0L, 0L, (CheckpointStreamFactory)this.testStreamFactory, CheckpointOptions.forCheckpointWithDefaultLocation());
            RocksDB spyDB = this.keyedStateBackend.db;
            for (RocksObject rocksCloseable : this.allCreatedCloseables) {
                ((RocksObject)Mockito.verify((Object)rocksCloseable, (VerificationMode)VerificationModeFactory.times((int)0))).close();
            }
            snapshot.cancel(true);
            this.keyedStateBackend.dispose();
            ((RocksDB)Mockito.verify((Object)spyDB, (VerificationMode)VerificationModeFactory.times((int)1))).close();
            Assert.assertEquals((Object)true, (Object)this.keyedStateBackend.isDisposed());
            for (RocksObject rocksCloseable : this.allCreatedCloseables) {
                ((RocksObject)Mockito.verify((Object)rocksCloseable, (VerificationMode)VerificationModeFactory.times((int)1))).close();
            }
        }
        finally {
            this.keyedStateBackend.dispose();
            this.keyedStateBackend = null;
        }
        this.verifyRocksDBStateUploaderClosed();
    }

    @Test
    public void testDismissingSnapshot() throws Exception {
        this.setupRocksKeyedStateBackend();
        try {
            RunnableFuture snapshot = this.keyedStateBackend.snapshot(0L, 0L, (CheckpointStreamFactory)this.testStreamFactory, CheckpointOptions.forCheckpointWithDefaultLocation());
            snapshot.cancel(true);
            this.verifyRocksObjectsReleased();
        }
        finally {
            this.keyedStateBackend.dispose();
            this.keyedStateBackend = null;
        }
        this.verifyRocksDBStateUploaderClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDismissingSnapshotNotRunnable() throws Exception {
        this.setupRocksKeyedStateBackend();
        try {
            RunnableFuture snapshot = this.keyedStateBackend.snapshot(0L, 0L, (CheckpointStreamFactory)this.testStreamFactory, CheckpointOptions.forCheckpointWithDefaultLocation());
            snapshot.cancel(true);
            Thread asyncSnapshotThread = new Thread(snapshot);
            asyncSnapshotThread.start();
            try {
                snapshot.get();
                Assert.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            asyncSnapshotThread.join();
            this.verifyRocksObjectsReleased();
        }
        finally {
            this.keyedStateBackend.dispose();
            this.keyedStateBackend = null;
        }
        this.verifyRocksDBStateUploaderClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompletingSnapshot() throws Exception {
        this.setupRocksKeyedStateBackend();
        try {
            RunnableFuture snapshot = this.keyedStateBackend.snapshot(0L, 0L, (CheckpointStreamFactory)this.testStreamFactory, CheckpointOptions.forCheckpointWithDefaultLocation());
            Thread asyncSnapshotThread = new Thread(snapshot);
            asyncSnapshotThread.start();
            this.waiter.await();
            this.waiter.reset();
            this.runStateUpdates();
            this.blocker.trigger();
            this.waiter.await();
            SnapshotResult snapshotResult = (SnapshotResult)snapshot.get();
            KeyedStateHandle keyedStateHandle = (KeyedStateHandle)snapshotResult.getJobManagerOwnedSnapshot();
            TestCase.assertNotNull((Object)keyedStateHandle);
            Assert.assertTrue((keyedStateHandle.getStateSize() > 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)2L, (long)keyedStateHandle.getKeyGroupRange().getNumberOfKeyGroups());
            for (BlockingCheckpointOutputStream stream : this.testStreamFactory.getAllCreatedStreams()) {
                Assert.assertTrue((boolean)stream.isClosed());
            }
            asyncSnapshotThread.join();
            this.verifyRocksObjectsReleased();
        }
        finally {
            this.keyedStateBackend.dispose();
            this.keyedStateBackend = null;
        }
        this.verifyRocksDBStateUploaderClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelRunningSnapshot() throws Exception {
        this.setupRocksKeyedStateBackend();
        try {
            RunnableFuture snapshot = this.keyedStateBackend.snapshot(0L, 0L, (CheckpointStreamFactory)this.testStreamFactory, CheckpointOptions.forCheckpointWithDefaultLocation());
            Thread asyncSnapshotThread = new Thread(snapshot);
            asyncSnapshotThread.start();
            this.waiter.await();
            this.waiter.reset();
            this.runStateUpdates();
            snapshot.cancel(true);
            this.blocker.trigger();
            for (BlockingCheckpointOutputStream stream : this.testStreamFactory.getAllCreatedStreams()) {
                Assert.assertTrue((boolean)stream.isClosed());
            }
            this.waiter.await();
            try {
                snapshot.get();
                Assert.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            asyncSnapshotThread.join();
            this.verifyRocksObjectsReleased();
        }
        finally {
            this.keyedStateBackend.dispose();
            this.keyedStateBackend = null;
        }
        this.verifyRocksDBStateUploaderClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisposeDeletesAllDirectories() throws Exception {
        CheckpointableKeyedStateBackend backend = this.createKeyedBackend((TypeSerializer)IntSerializer.INSTANCE);
        Collection allFilesInDbDir = FileUtils.listFilesAndDirs((File)new File(this.dbPath), (IOFileFilter)new AcceptAllFilter(), (IOFileFilter)new AcceptAllFilter());
        try {
            ValueStateDescriptor kvId = new ValueStateDescriptor("id", String.class, null);
            kvId.initializeSerializerUnlessSet(new ExecutionConfig());
            ValueState state = (ValueState)backend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, (StateDescriptor)kvId);
            backend.setCurrentKey((Object)1);
            state.update((Object)"Hello");
            Assert.assertTrue((allFilesInDbDir.size() > 1 ? 1 : 0) != 0);
        }
        finally {
            IOUtils.closeQuietly((AutoCloseable)backend);
            backend.dispose();
        }
        allFilesInDbDir = FileUtils.listFilesAndDirs((File)new File(this.dbPath), (IOFileFilter)new AcceptAllFilter(), (IOFileFilter)new AcceptAllFilter());
        Assert.assertEquals((long)1L, (long)allFilesInDbDir.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSharedIncrementalStateDeRegistration() throws Exception {
        if (this.enableIncrementalCheckpointing) {
            CheckpointableKeyedStateBackend backend = this.createKeyedBackend((TypeSerializer)IntSerializer.INSTANCE);
            try {
                ValueStateDescriptor kvId = new ValueStateDescriptor("id", String.class, null);
                kvId.initializeSerializerUnlessSet(new ExecutionConfig());
                ValueState state = (ValueState)backend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, (StateDescriptor)kvId);
                LinkedList<IncrementalRemoteKeyedStateHandle> previousStateHandles = new LinkedList<IncrementalRemoteKeyedStateHandle>();
                SharedStateRegistry sharedStateRegistry = (SharedStateRegistry)Mockito.spy((Object)new SharedStateRegistryImpl());
                for (int checkpointId = 0; checkpointId < 3; ++checkpointId) {
                    Mockito.reset((Object[])new SharedStateRegistry[]{sharedStateRegistry});
                    backend.setCurrentKey((Object)checkpointId);
                    state.update((Object)("Hello-" + checkpointId));
                    RunnableFuture snapshot = backend.snapshot((long)checkpointId, (long)checkpointId, this.createStreamFactory(), CheckpointOptions.forCheckpointWithDefaultLocation());
                    snapshot.run();
                    SnapshotResult snapshotResult = (SnapshotResult)snapshot.get();
                    IncrementalRemoteKeyedStateHandle stateHandle = (IncrementalRemoteKeyedStateHandle)snapshotResult.getJobManagerOwnedSnapshot();
                    List sharedState = stateHandle.getSharedState().stream().map(e -> IncrementalKeyedStateHandle.HandleAndLocalPath.of((StreamStateHandle)e.getHandle(), (String)e.getLocalPath())).collect(Collectors.toList());
                    stateHandle.registerSharedStates(sharedStateRegistry, (long)checkpointId);
                    for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : sharedState) {
                        ((SharedStateRegistry)Mockito.verify((Object)sharedStateRegistry)).registerReference(stateHandle.createSharedStateRegistryKey(handleAndLocalPath.getHandle()), handleAndLocalPath.getHandle(), (long)checkpointId);
                    }
                    previousStateHandles.add(stateHandle);
                    ((CheckpointListener)backend).notifyCheckpointComplete((long)checkpointId);
                    if (previousStateHandles.size() <= 1) continue;
                    ((IncrementalRemoteKeyedStateHandle)previousStateHandles.remove()).discardState();
                }
                while (!previousStateHandles.isEmpty()) {
                    Mockito.reset((Object[])new SharedStateRegistry[]{sharedStateRegistry});
                    ((IncrementalRemoteKeyedStateHandle)previousStateHandles.remove()).discardState();
                }
            }
            finally {
                IOUtils.closeQuietly((AutoCloseable)backend);
                backend.dispose();
            }
        }
    }

    @Test(expected=FlinkRuntimeException.class)
    public void testMapStateClear() throws Exception {
        this.setupRocksKeyedStateBackend();
        MapStateDescriptor kvId = new MapStateDescriptor("id", Integer.class, String.class);
        MapState state = (MapState)this.keyedStateBackend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, (StateDescriptor)kvId);
        ((RocksDB)Mockito.doAnswer(invocationOnMock -> {
            throw new RocksDBException("Artificial failure");
        }).when((Object)this.keyedStateBackend.db)).newIterator((ColumnFamilyHandle)Matchers.any(ColumnFamilyHandle.class), (ReadOptions)Matchers.any(ReadOptions.class));
        state.clear();
    }

    private void runStateUpdates() throws Exception {
        for (int i = 50; i < 150; ++i) {
            if (i % 10 == 0) {
                Thread.sleep(1L);
            }
            this.keyedStateBackend.setCurrentKey((Object)i);
            this.testState1.update((Object)(4200 + i));
            this.testState2.update((Object)("S-" + (4200 + i)));
        }
    }

    private void verifyRocksObjectsReleased() {
        for (RocksObject rocksCloseable : this.allCreatedCloseables) {
            ((RocksObject)Mockito.verify((Object)rocksCloseable, (VerificationMode)VerificationModeFactory.times((int)1))).close();
        }
        TestCase.assertNotNull(null, (Object)this.keyedStateBackend.db);
        RocksDB spyDB = this.keyedStateBackend.db;
        this.keyedStateBackend.dispose();
        ((RocksDB)Mockito.verify((Object)spyDB, (VerificationMode)VerificationModeFactory.times((int)1))).close();
        Assert.assertEquals((Object)true, (Object)this.keyedStateBackend.isDisposed());
    }

    private void verifyRocksDBStateUploaderClosed() {
        if (this.enableIncrementalCheckpointing) {
            ((RocksDBStateUploader)Mockito.verify((Object)this.rocksDBStateUploader, (VerificationMode)VerificationModeFactory.times((int)1))).close();
        }
    }

    private static class AcceptAllFilter
    implements IOFileFilter {
        private AcceptAllFilter() {
        }

        public boolean accept(File file) {
            return true;
        }

        public boolean accept(File file, String s) {
            return true;
        }
    }
}

