/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog.restore;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class FunctionDelegationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionDelegationHelper.class);
    private final Map<String, DelegatingFunction> delegatingFunctions = new HashMap<String, DelegatingFunction>();

    public static <T> ReduceFunction<T> delegateReduceFunction() {
        return new DelegatingReduceFunction();
    }

    public static <IN, ACC, OUT> AggregateFunction<IN, ACC, OUT> delegateAggregateFunction() {
        return new DelegatingAggregateFunction();
    }

    public <T, S extends State, F> void addOrUpdate(StateDescriptor<S, T> stateDescriptor) {
        F function = FunctionDelegationHelper.tryGetFunction(stateDescriptor);
        String name = stateDescriptor.getName();
        if (function instanceof DelegatingFunction) {
            LOG.debug("add delegate: {}", (Object)name);
            this.delegatingFunctions.putIfAbsent(name, (DelegatingFunction)function);
        } else {
            DelegatingFunction delegating = this.delegatingFunctions.get(name);
            if (delegating != null) {
                LOG.debug("update delegate: {}", (Object)name);
                Preconditions.checkState((function != null ? 1 : 0) != 0, (Object)("unable to extract function for state " + name));
                delegating.delegateIfNeeded(function);
            }
        }
    }

    @Nullable
    private static <F extends Function> F tryGetFunction(StateDescriptor<?, ?> stateDescriptor) {
        if (stateDescriptor instanceof ReducingStateDescriptor) {
            return (F)((ReducingStateDescriptor)stateDescriptor).getReduceFunction();
        }
        if (stateDescriptor instanceof AggregatingStateDescriptor) {
            return (F)((AggregatingStateDescriptor)stateDescriptor).getAggregateFunction();
        }
        return null;
    }

    static class DelegatingReduceFunction<T>
    implements ReduceFunction<T>,
    DelegatingFunction<ReduceFunction<T>> {
        private static final long serialVersionUID = 1L;
        @Nullable
        private ReduceFunction<T> delegated;

        DelegatingReduceFunction() {
        }

        public T reduce(T left, T right) throws Exception {
            Preconditions.checkNotNull(this.delegated);
            return (T)this.delegated.reduce(left, right);
        }

        @Override
        public void delegateIfNeeded(ReduceFunction<T> delegated) {
            if (this.delegated == null) {
                this.delegated = (ReduceFunction)Preconditions.checkNotNull(delegated);
            }
        }
    }

    static class DelegatingAggregateFunction<IN, ACC, OUT>
    implements AggregateFunction<IN, ACC, OUT>,
    DelegatingFunction<AggregateFunction<IN, ACC, OUT>> {
        private static final long serialVersionUID = 1L;
        @Nullable
        private AggregateFunction<IN, ACC, OUT> delegated;

        DelegatingAggregateFunction() {
        }

        @Override
        public void delegateIfNeeded(AggregateFunction<IN, ACC, OUT> delegated) {
            if (this.delegated == null) {
                this.delegated = (AggregateFunction)Preconditions.checkNotNull(delegated);
            }
        }

        public ACC createAccumulator() {
            Preconditions.checkNotNull(this.delegated);
            return (ACC)this.delegated.createAccumulator();
        }

        public ACC add(IN value, ACC accumulator) {
            Preconditions.checkNotNull(this.delegated);
            return (ACC)this.delegated.add(value, accumulator);
        }

        public OUT getResult(ACC accumulator) {
            Preconditions.checkNotNull(this.delegated);
            return (OUT)this.delegated.getResult(accumulator);
        }

        public ACC merge(ACC a, ACC b) {
            Preconditions.checkNotNull(this.delegated);
            return (ACC)this.delegated.merge(a, b);
        }
    }

    private static interface DelegatingFunction<F>
    extends Function {
        public void delegateIfNeeded(F var1);
    }
}

