/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.bouncycastle.crypto.generators;

import java.security.SecureRandom;
import org.apache.pulsar.shade.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.apache.pulsar.shade.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.apache.pulsar.shade.org.bouncycastle.crypto.KeyGenerationParameters;
import org.apache.pulsar.shade.org.bouncycastle.crypto.params.X448PrivateKeyParameters;
import org.apache.pulsar.shade.org.bouncycastle.crypto.params.X448PublicKeyParameters;

public class X448KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        X448PrivateKeyParameters x448PrivateKeyParameters = new X448PrivateKeyParameters(this.random);
        X448PublicKeyParameters x448PublicKeyParameters = x448PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(x448PublicKeyParameters, x448PrivateKeyParameters);
    }
}

