/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.scurrilous.circe.checksum;

import org.apache.pulsar.shade.com.scurrilous.circe.checksum.IntHash;
import org.apache.pulsar.shade.com.scurrilous.circe.checksum.Java8IntHash;
import org.apache.pulsar.shade.com.scurrilous.circe.checksum.Java9IntHash;
import org.apache.pulsar.shade.com.scurrilous.circe.checksum.JniIntHash;
import org.apache.pulsar.shade.com.scurrilous.circe.crc.Sse42Crc32C;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;

public class Crc32cIntChecksum {
    private static final IntHash CRC32C_HASH = Sse42Crc32C.isSupported() ? new JniIntHash() : (Java9IntHash.HAS_JAVA9_CRC32C ? new Java9IntHash() : new Java8IntHash());

    public static int computeChecksum(ByteBuf payload) {
        return CRC32C_HASH.calculate(payload);
    }

    public static int resumeChecksum(int previousChecksum, ByteBuf payload) {
        return CRC32C_HASH.resume(previousChecksum, payload);
    }
}

