/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.subscriber.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.connector.pulsar.source.enumerator.subscriber.impl.BasePulsarSubscriber;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicMetadata;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicNameUtils;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicRange;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.RangeGenerator;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.naming.TopicName;

public class TopicListSubscriber
extends BasePulsarSubscriber {
    private static final long serialVersionUID = 6473918213832993116L;
    private final Set<String> partitions = new HashSet<String>();
    private final Set<String> fullTopicNames = new HashSet<String>();

    public TopicListSubscriber(List<String> fullTopicNameOrPartitions) {
        for (String fullTopicNameOrPartition : fullTopicNameOrPartitions) {
            if (TopicNameUtils.isPartition(fullTopicNameOrPartition)) {
                this.partitions.add(fullTopicNameOrPartition);
                continue;
            }
            this.fullTopicNames.add(fullTopicNameOrPartition);
        }
    }

    @Override
    public Set<TopicPartition> getSubscribedTopicPartitions(RangeGenerator generator, int parallelism) throws PulsarAdminException {
        Set<TopicPartition> results = this.createTopicPartitions(this.fullTopicNames, generator, parallelism);
        for (String partition : this.partitions) {
            TopicName topicName = TopicName.get(partition);
            String name = topicName.getPartitionedTopicName();
            int index = topicName.getPartitionIndex();
            TopicMetadata metadata = this.queryTopicMetadata(partition);
            if (metadata == null) continue;
            List<TopicRange> ranges = generator.range(metadata, parallelism);
            results.add(new TopicPartition(name, index, ranges));
        }
        return results;
    }
}

