/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Set;
import org.apache.flink.connector.pulsar.common.utils.PulsarSerdeUtils;
import org.apache.flink.connector.pulsar.source.enumerator.PulsarSourceEnumState;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplit;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplitSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.util.function.FunctionWithException;

public class PulsarSourceEnumStateSerializer
implements SimpleVersionedSerializer<PulsarSourceEnumState> {
    public static final int CURRENT_VERSION = 3;
    public static final PulsarSourceEnumStateSerializer INSTANCE = new PulsarSourceEnumStateSerializer();
    private static final PulsarPartitionSplitSerializer SPLIT_SERIALIZER = PulsarPartitionSplitSerializer.INSTANCE;

    private PulsarSourceEnumStateSerializer() {
    }

    public int getVersion() {
        return 3;
    }

    public byte[] serialize(PulsarSourceEnumState obj) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream out = new DataOutputStream(baos);){
                PulsarSerdeUtils.serializeSet(out, obj.getAppendedPartitions(), SPLIT_SERIALIZER::serializeTopicPartition);
                out.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public PulsarSourceEnumState deserialize(int version, byte[] serialized) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
            PulsarSourceEnumState pulsarSourceEnumState;
            try (DataInputStream in = new DataInputStream(bais);){
                Set<TopicPartition> partitions = null;
                partitions = version == 3 ? PulsarSerdeUtils.deserializeSet(in, this.deserializePartition(2)) : (version == 2 ? PulsarSerdeUtils.deserializeSet(in, this.deserializePartition(1)) : PulsarSerdeUtils.deserializeSet(in, this.deserializePartition(0)));
                if (version == 0) {
                    PulsarSerdeUtils.deserializeSet(in, this.deserializeSplit());
                    PulsarSerdeUtils.deserializeMap(in, DataInput::readInt, i -> PulsarSerdeUtils.deserializeSet(i, this.deserializeSplit()));
                    PulsarSerdeUtils.deserializeMap(in, DataInput::readInt, i -> PulsarSerdeUtils.deserializeSet(i, DataInput::readUTF));
                    in.readBoolean();
                }
                pulsarSourceEnumState = new PulsarSourceEnumState(partitions);
            }
            return pulsarSourceEnumState;
        }
    }

    private FunctionWithException<DataInputStream, TopicPartition, IOException> deserializePartition(int version) {
        return in -> SPLIT_SERIALIZER.deserializeTopicPartition(version, (DataInputStream)in);
    }

    private FunctionWithException<DataInputStream, PulsarPartitionSplit, IOException> deserializeSplit() {
        return in -> SPLIT_SERIALIZER.deserializePulsarPartitionSplit(0, (DataInputStream)in);
    }
}

