/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink.writer.message;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.pulsar.sink.writer.message.PulsarMessageBuilder;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.Schema;

@PublicEvolving
public class PulsarMessage<T> {
    @Nullable
    private final byte[] orderingKey;
    @Nullable
    private final String key;
    private final long eventTime;
    @Nullable
    private final Schema<T> schema;
    @Nullable
    private final T value;
    @Nullable
    private final Map<String, String> properties;
    @Nullable
    private final Long sequenceId;
    @Nullable
    private final List<String> replicationClusters;
    private final boolean disableReplication;

    PulsarMessage(@Nullable byte[] orderingKey, @Nullable String key, long eventTime, @Nullable Schema<T> schema, @Nullable T value, @Nullable Map<String, String> properties, @Nullable Long sequenceId, @Nullable List<String> replicationClusters, boolean disableReplication) {
        this.orderingKey = orderingKey;
        this.key = key;
        this.eventTime = eventTime;
        this.schema = schema;
        this.value = value;
        this.properties = properties;
        this.sequenceId = sequenceId;
        this.replicationClusters = replicationClusters;
        this.disableReplication = disableReplication;
    }

    public static <M> PulsarMessageBuilder<M> builder(Schema<M> schema, M message) {
        Preconditions.checkNotNull(schema, (String)"Schema should be provided.");
        Preconditions.checkNotNull(message, (String)"Message should be provided.");
        return new PulsarMessageBuilder<M>(schema, message);
    }

    public static PulsarMessageBuilder<byte[]> builder(byte[] bytes) {
        Preconditions.checkNotNull((Object)bytes, (String)"Message bytes should be provided.");
        return new PulsarMessageBuilder<byte[]>(Schema.BYTES, bytes);
    }

    public static PulsarMessageBuilder<byte[]> builder() {
        return new PulsarMessageBuilder<Object>(null, null);
    }

    @Nullable
    public byte[] getOrderingKey() {
        return this.orderingKey;
    }

    @Nullable
    public String getKey() {
        return this.key;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    @Nullable
    public Schema<T> getSchema() {
        return this.schema;
    }

    @Nullable
    public T getValue() {
        return this.value;
    }

    @Nullable
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Nullable
    public Long getSequenceId() {
        return this.sequenceId;
    }

    @Nullable
    public List<String> getReplicationClusters() {
        return this.replicationClusters;
    }

    public boolean isDisableReplication() {
        return this.disableReplication;
    }
}

