/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.ConfigGroup;
import org.apache.flink.annotation.docs.ConfigGroups;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.LinkElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.pulsar.common.config.PulsarOptions;
import org.apache.flink.connector.pulsar.sink.writer.router.MessageKeyHash;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.ProducerCryptoFailureAction;

@ConfigGroups(groups={@ConfigGroup(name="PulsarSink", keyPrefix="pulsar.sink."), @ConfigGroup(name="PulsarProducer", keyPrefix="pulsar.producer.")})
@PublicEvolving
public final class PulsarSinkOptions {
    public static final String SINK_CONFIG_PREFIX = "pulsar.sink.";
    public static final String PRODUCER_CONFIG_PREFIX = "pulsar.producer.";
    public static final ConfigOption<DeliveryGuarantee> PULSAR_WRITE_DELIVERY_GUARANTEE = ConfigOptions.key((String)"pulsar.sink.deliveryGuarantee").enumType(DeliveryGuarantee.class).defaultValue((Object)DeliveryGuarantee.NONE).withDescription("Optional delivery guarantee when committing.");
    public static final ConfigOption<Long> PULSAR_WRITE_TRANSACTION_TIMEOUT = ConfigOptions.key((String)"pulsar.sink.transactionTimeoutMillis").longType().defaultValue((Object)Duration.ofHours(3L).toMillis()).withDescription(Description.builder().text("This option is used when the user require the %s semantic. ", new InlineElement[]{TextElement.code((String)"DeliveryGuarantee.EXACTLY_ONCE")}).text("We would use transaction for making sure the message could be write only once.").build());
    public static final ConfigOption<Long> PULSAR_TOPIC_METADATA_REFRESH_INTERVAL = ConfigOptions.key((String)"pulsar.sink.topicMetadataRefreshInterval").longType().defaultValue((Object)Duration.ofMinutes(30L).toMillis()).withDescription("Auto update the topic metadata in a fixed interval (in ms). The default value is 30 minutes.");
    public static final ConfigOption<MessageKeyHash> PULSAR_MESSAGE_KEY_HASH = ConfigOptions.key((String)"pulsar.sink.messageKeyHash").enumType(MessageKeyHash.class).defaultValue((Object)MessageKeyHash.MURMUR3_32_HASH).withDescription("The hash policy for routing message by calculating the hash code of message key.");
    public static final ConfigOption<Boolean> PULSAR_WRITE_SCHEMA_EVOLUTION = ConfigOptions.key((String)"pulsar.sink.enableSchemaEvolution").booleanType().defaultValue((Object)false).withDescription(Description.builder().text("If you enable this option and use %s, we would produce and serialize the message by using Pulsar's %s.", new InlineElement[]{TextElement.code((String)"PulsarSinkBuilder.setSerializationSchema(Schema)"), TextElement.code((String)"Schema")}).build());
    public static final ConfigOption<Integer> PULSAR_MAX_RECOMMIT_TIMES = ConfigOptions.key((String)"pulsar.sink.maxRecommitTimes").intType().defaultValue((Object)5).withDescription("The allowed transaction recommit times if we meet some retryable exception. This is used in Pulsar Transaction.");
    public static final ConfigOption<Boolean> PULSAR_ENABLE_SINK_METRICS = ConfigOptions.key((String)"pulsar.sink.enableMetrics").booleanType().defaultValue((Object)true).withDescription(Description.builder().text("The metrics from Pulsar Producer are only exposed if you enable this option. ").text("You should set the %s to a positive value if you enable this option.", new InlineElement[]{TextElement.code((String)PulsarOptions.PULSAR_STATS_INTERVAL_SECONDS.key())}).build());
    public static final ConfigOption<Boolean> PULSAR_VALIDATE_SINK_MESSAGE_BYTES = ConfigOptions.key((String)"pulsar.sink.validateSinkMessageBytes").booleanType().defaultValue((Object)false).withDescription(Description.builder().text("Pulsar client can validate the raw message bytes with the latest topic schema. ").text("This can make sure your serialized messages bytes is valid for consumer.").build());
    public static final ConfigOption<String> PULSAR_PRODUCER_NAME = ConfigOptions.key((String)"pulsar.producer.producerName").stringType().noDefaultValue().withDescription("A producer name which would be displayed in the Pulsar's dashboard. If no producer name was provided, we would use a Pulsar generated name instead.");
    public static final ConfigOption<Long> PULSAR_SEND_TIMEOUT_MS = ConfigOptions.key((String)"pulsar.producer.sendTimeoutMs").longType().defaultValue((Object)30000L).withDescription(Description.builder().text("Message send timeout in ms.").text("If a message is not acknowledged by a server before the %s expires, an error occurs.", new InlineElement[]{TextElement.code((String)"sendTimeout")}).build());
    public static final ConfigOption<Long> PULSAR_BATCHING_MAX_PUBLISH_DELAY_MICROS = ConfigOptions.key((String)"pulsar.producer.batchingMaxPublishDelayMicros").longType().defaultValue((Object)TimeUnit.MILLISECONDS.toMicros(1L)).withDescription("Batching time period of sending messages.");
    public static final ConfigOption<Integer> PULSAR_BATCHING_PARTITION_SWITCH_FREQUENCY_BY_PUBLISH_DELAY = ConfigOptions.key((String)"pulsar.producer.batchingPartitionSwitchFrequencyByPublishDelay").intType().defaultValue((Object)10).withDescription("The maximum wait time for switching topic partitions.");
    public static final ConfigOption<Integer> PULSAR_BATCHING_MAX_MESSAGES = ConfigOptions.key((String)"pulsar.producer.batchingMaxMessages").intType().defaultValue((Object)1000).withDescription("The maximum number of messages permitted in a batch.");
    public static final ConfigOption<Integer> PULSAR_BATCHING_MAX_BYTES = ConfigOptions.key((String)"pulsar.producer.batchingMaxBytes").intType().defaultValue((Object)131072).withDescription("The maximum size of messages permitted in a batch. Keep the maximum consistent as previous versions.");
    public static final ConfigOption<Boolean> PULSAR_BATCHING_ENABLED = ConfigOptions.key((String)"pulsar.producer.batchingEnabled").booleanType().defaultValue((Object)true).withDescription("Enable batch send ability, it was enabled by default.");
    public static final ConfigOption<Boolean> PULSAR_CHUNKING_ENABLED = ConfigOptions.key((String)"pulsar.producer.chunkingEnabled").booleanType().defaultValue((Object)false).withDescription(Description.builder().text("If message size is higher than allowed max publish-payload size by broker,").text(" then enableChunking helps producer to split message into multiple chunks").text(" and publish them to broker separately and in order.").text(" So, it allows client to successfully publish large size of messages in pulsar.").build());
    public static final ConfigOption<Integer> PULSAR_CHUNK_MAX_MESSAGE_SIZE = ConfigOptions.key((String)"pulsar.producer.chunkMaxMessageSize").intType().defaultValue((Object)-1).withDescription(Description.builder().text("Max chunk message size in bytes.").text(" Producer chunks the message if chunking is enabled and message size is larger than max chunk-message size.").text(" By default, chunkMaxMessageSize value is -1 and producer chunks based on max-message size configured at the broker.").build());
    public static final ConfigOption<CompressionType> PULSAR_COMPRESSION_TYPE = ConfigOptions.key((String)"pulsar.producer.compressionType").enumType(CompressionType.class).defaultValue((Object)CompressionType.NONE).withDescription(Description.builder().text("Message data compression type used by a producer.").text("Available options:").list(new InlineElement[]{LinkElement.link((String)"https://github.com/lz4/lz4", (String)"LZ4"), LinkElement.link((String)"https://zlib.net/", (String)"ZLIB"), LinkElement.link((String)"https://facebook.github.io/zstd/", (String)"ZSTD"), LinkElement.link((String)"https://google.github.io/snappy/", (String)"SNAPPY")}).build());
    public static final ConfigOption<Long> PULSAR_INITIAL_SEQUENCE_ID = ConfigOptions.key((String)"pulsar.producer.initialSequenceId").longType().noDefaultValue().withDescription("The sequence id for avoiding the duplication, it's used when Pulsar doesn't have transaction.");
    public static final ConfigOption<Map<String, String>> PULSAR_PRODUCER_PROPERTIES = ConfigOptions.key((String)"pulsar.producer.properties").mapType().defaultValue(Collections.emptyMap()).withDescription(Description.builder().text("A name or value property of this consumer.").text(" %s is application defined metadata attached to a consumer.", new InlineElement[]{TextElement.code((String)"properties")}).text(" When getting a topic stats, associate this metadata with the consumer stats for easier identification.").build());
    public static final ConfigOption<ProducerCryptoFailureAction> PULSAR_PRODUCER_CRYPTO_FAILURE_ACTION = ConfigOptions.key((String)"pulsar.producer.producerCryptoFailureAction").enumType(ProducerCryptoFailureAction.class).defaultValue((Object)ProducerCryptoFailureAction.FAIL).withDescription("The action the producer will take in case of encryption failures.");

    private PulsarSinkOptions() {
    }
}

