/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.schema.factories;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchemaFactory;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.google.common.collect.ImmutableSet;

public class PrimitiveSchemaFactory<T>
implements PulsarSchemaFactory<T> {
    private static final ImmutableSet<SchemaType> PRIMITIVE_SCHEMA_TYPES = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add((Object)SchemaType.NONE)).add((Object)SchemaType.BOOLEAN)).add((Object)SchemaType.INT8)).add((Object)SchemaType.INT16)).add((Object)SchemaType.INT32)).add((Object)SchemaType.INT64)).add((Object)SchemaType.FLOAT)).add((Object)SchemaType.DOUBLE)).add((Object)SchemaType.BYTES)).add((Object)SchemaType.STRING)).add((Object)SchemaType.TIMESTAMP)).add((Object)SchemaType.TIME)).add((Object)SchemaType.DATE)).add((Object)SchemaType.INSTANT)).add((Object)SchemaType.LOCAL_DATE)).add((Object)SchemaType.LOCAL_TIME)).add((Object)SchemaType.LOCAL_DATE_TIME)).build();
    private final SchemaType type;
    private final Schema<T> schema;
    private final TypeInformation<T> typeInformation;

    public PrimitiveSchemaFactory(Schema<T> schema, TypeInformation<T> typeInformation) {
        this(schema.getSchemaInfo().getType(), schema, typeInformation);
    }

    public PrimitiveSchemaFactory(SchemaType type, Schema<T> schema, TypeInformation<T> typeInformation) {
        Preconditions.checkArgument((boolean)PRIMITIVE_SCHEMA_TYPES.contains((Object)type));
        this.type = type;
        this.schema = schema;
        this.typeInformation = typeInformation;
    }

    @Override
    public SchemaType type() {
        return this.type;
    }

    @Override
    public Schema<T> createSchema(SchemaInfo info) {
        return this.schema;
    }

    @Override
    public TypeInformation<T> createTypeInfo(SchemaInfo info) {
        return this.typeInformation;
    }
}

