/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.source.reader.fetcher;

import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.connector.base.source.reader.fetcher.SplitFetcherTask;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.connector.base.source.reader.splitreader.SplitsAddition;

@Internal
class AddSplitsTask<SplitT extends SourceSplit>
implements SplitFetcherTask {
    private final SplitReader<?, SplitT> splitReader;
    private final List<SplitT> splitsToAdd;
    private final Map<String, SplitT> assignedSplits;

    AddSplitsTask(SplitReader<?, SplitT> splitReader, List<SplitT> splitsToAdd, Map<String, SplitT> assignedSplits) {
        this.splitReader = splitReader;
        this.splitsToAdd = splitsToAdd;
        this.assignedSplits = assignedSplits;
    }

    @Override
    public boolean run() {
        for (SourceSplit s2 : this.splitsToAdd) {
            this.assignedSplits.put(s2.splitId(), s2);
        }
        this.splitReader.handleSplitsChanges(new SplitsAddition<SplitT>(this.splitsToAdd));
        return true;
    }

    @Override
    public void wakeUp() {
    }

    public String toString() {
        return String.format("AddSplitsTask: [%s]", this.splitsToAdd);
    }
}

