/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.serialization;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.connectors.kinesis.serialization.KinesisDeserializationSchema;
import org.apache.flink.util.Collector;

@Internal
public class KinesisDeserializationSchemaWrapper<T>
implements KinesisDeserializationSchema<T> {
    private static final long serialVersionUID = 9143148962928375886L;
    private final DeserializationSchema<T> deserializationSchema;

    public KinesisDeserializationSchemaWrapper(DeserializationSchema<T> deserializationSchema) {
        try {
            Class<?> deserilizationClass = deserializationSchema.getClass();
            if (!deserilizationClass.getMethod("deserialize", byte[].class, Collector.class).isDefault()) {
                throw new IllegalArgumentException("Kinesis consumer does not support DeserializationSchema that implements deserialization with a Collector. Unsupported DeserializationSchema: " + deserilizationClass.getName());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.deserializationSchema = deserializationSchema;
    }

    @Override
    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.deserializationSchema.open(context);
    }

    @Override
    public T deserialize(byte[] recordValue, String partitionKey, String seqNum, long approxArrivalTimestamp, String stream, String shardId) throws IOException {
        return (T)this.deserializationSchema.deserialize(recordValue);
    }

    public TypeInformation<T> getProducedType() {
        return this.deserializationSchema.getProducedType();
    }
}

