/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkProtectedApi;

@SdkProtectedApi
public final class CompletableFutureUtils {
    private CompletableFutureUtils() {
    }

    public static <U> CompletableFuture<U> failedFuture(Throwable t) {
        CompletableFuture cf = new CompletableFuture();
        cf.completeExceptionally(t);
        return cf;
    }

    public static CompletionException errorAsCompletionException(Throwable t) {
        if (t instanceof CompletionException) {
            return (CompletionException)t;
        }
        return new CompletionException(t);
    }

    public static <T> CompletableFuture<T> forwardExceptionTo(CompletableFuture<T> src, CompletableFuture<?> dst) {
        src.whenComplete((r, e) -> {
            if (e != null) {
                dst.completeExceptionally((Throwable)e);
            }
        });
        return src;
    }

    public static <T> CompletableFuture<T> forwardTransformedExceptionTo(CompletableFuture<T> src, CompletableFuture<?> dst, Function<Throwable, Throwable> transformationFunction) {
        src.whenComplete((r, e) -> {
            if (e != null) {
                dst.completeExceptionally((Throwable)transformationFunction.apply((Throwable)e));
            }
        });
        return src;
    }

    public static <T> CompletableFuture<T> forwardResultTo(CompletableFuture<T> src, CompletableFuture<T> dst, Executor executor) {
        src.whenCompleteAsync((r, e) -> {
            if (e != null) {
                dst.completeExceptionally((Throwable)e);
            } else {
                dst.complete(r);
            }
        }, executor);
        return src;
    }

    public static <SourceT, DestT> CompletableFuture<SourceT> forwardTransformedResultTo(CompletableFuture<SourceT> src, CompletableFuture<DestT> dst, Function<SourceT, DestT> function) {
        src.whenComplete((r, e) -> {
            if (e != null) {
                dst.completeExceptionally((Throwable)e);
            } else {
                dst.complete(function.apply(r));
            }
        });
        return src;
    }
}

