/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkField;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkPojo;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.traits.ListTrait;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.traits.LocationTrait;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.util.SdkAutoConstructList;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ChildShard;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ChildShardListCopier;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.Record;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.RecordListCopier;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SubscribeToShardEventStream;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SubscribeToShardResponseHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SubscribeToShardEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubscribeToShardEvent>,
SubscribeToShardEventStream {
    private static final SdkField<List<Record>> RECORDS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("Records").getter(SubscribeToShardEvent.getter(SubscribeToShardEvent::records)).setter(SubscribeToShardEvent.setter(Builder::records)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(Record::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> CONTINUATION_SEQUENCE_NUMBER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ContinuationSequenceNumber").getter(SubscribeToShardEvent.getter(SubscribeToShardEvent::continuationSequenceNumber)).setter(SubscribeToShardEvent.setter(Builder::continuationSequenceNumber)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuationSequenceNumber").build()).build();
    private static final SdkField<Long> MILLIS_BEHIND_LATEST_FIELD = SdkField.builder(MarshallingType.LONG).memberName("MillisBehindLatest").getter(SubscribeToShardEvent.getter(SubscribeToShardEvent::millisBehindLatest)).setter(SubscribeToShardEvent.setter(Builder::millisBehindLatest)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MillisBehindLatest").build()).build();
    private static final SdkField<List<ChildShard>> CHILD_SHARDS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("ChildShards").getter(SubscribeToShardEvent.getter(SubscribeToShardEvent::childShards)).setter(SubscribeToShardEvent.setter(Builder::childShards)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChildShards").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(ChildShard::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_FIELD, CONTINUATION_SEQUENCE_NUMBER_FIELD, MILLIS_BEHIND_LATEST_FIELD, CHILD_SHARDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Record> records;
    private final String continuationSequenceNumber;
    private final Long millisBehindLatest;
    private final List<ChildShard> childShards;

    protected SubscribeToShardEvent(BuilderImpl builder) {
        this.records = builder.records;
        this.continuationSequenceNumber = builder.continuationSequenceNumber;
        this.millisBehindLatest = builder.millisBehindLatest;
        this.childShards = builder.childShards;
    }

    public final boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public final List<Record> records() {
        return this.records;
    }

    public final String continuationSequenceNumber() {
        return this.continuationSequenceNumber;
    }

    public final Long millisBehindLatest() {
        return this.millisBehindLatest;
    }

    public final boolean hasChildShards() {
        return this.childShards != null && !(this.childShards instanceof SdkAutoConstructList);
    }

    public final List<ChildShard> childShards() {
        return this.childShards;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecords() ? this.records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.continuationSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.millisBehindLatest());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChildShards() ? this.childShards() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribeToShardEvent)) {
            return false;
        }
        SubscribeToShardEvent other = (SubscribeToShardEvent)obj;
        return this.hasRecords() == other.hasRecords() && Objects.equals(this.records(), other.records()) && Objects.equals(this.continuationSequenceNumber(), other.continuationSequenceNumber()) && Objects.equals(this.millisBehindLatest(), other.millisBehindLatest()) && this.hasChildShards() == other.hasChildShards() && Objects.equals(this.childShards(), other.childShards());
    }

    public final String toString() {
        return ToString.builder("SubscribeToShardEvent").add("Records", this.hasRecords() ? this.records() : null).add("ContinuationSequenceNumber", this.continuationSequenceNumber()).add("MillisBehindLatest", this.millisBehindLatest()).add("ChildShards", this.hasChildShards() ? this.childShards() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
            case "ContinuationSequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.continuationSequenceNumber()));
            }
            case "MillisBehindLatest": {
                return Optional.ofNullable(clazz.cast(this.millisBehindLatest()));
            }
            case "ChildShards": {
                return Optional.ofNullable(clazz.cast(this.childShards()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final SubscribeToShardEvent copy(Consumer<? super Builder> modifier) {
        return (SubscribeToShardEvent)ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubscribeToShardEvent, T> g) {
        return obj -> g.apply((SubscribeToShardEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    @Override
    public SubscribeToShardEventStream.EventType sdkEventType() {
        return SubscribeToShardEventStream.EventType.SUBSCRIBE_TO_SHARD_EVENT;
    }

    @Override
    public void accept(SubscribeToShardResponseHandler.Visitor visitor) {
        visitor.visit(this);
    }

    protected static class BuilderImpl
    implements Builder {
        private List<Record> records = DefaultSdkAutoConstructList.getInstance();
        private String continuationSequenceNumber;
        private Long millisBehindLatest;
        private List<ChildShard> childShards = DefaultSdkAutoConstructList.getInstance();

        protected BuilderImpl() {
        }

        protected BuilderImpl(SubscribeToShardEvent model) {
            this.records(model.records);
            this.continuationSequenceNumber(model.continuationSequenceNumber);
            this.millisBehindLatest(model.millisBehindLatest);
            this.childShards(model.childShards);
        }

        public final List<Record.Builder> getRecords() {
            List<Record.Builder> result = RecordListCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = RecordListCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<Record.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (Record)((Record.Builder)Record.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getContinuationSequenceNumber() {
            return this.continuationSequenceNumber;
        }

        public final void setContinuationSequenceNumber(String continuationSequenceNumber) {
            this.continuationSequenceNumber = continuationSequenceNumber;
        }

        @Override
        public final Builder continuationSequenceNumber(String continuationSequenceNumber) {
            this.continuationSequenceNumber = continuationSequenceNumber;
            return this;
        }

        public final Long getMillisBehindLatest() {
            return this.millisBehindLatest;
        }

        public final void setMillisBehindLatest(Long millisBehindLatest) {
            this.millisBehindLatest = millisBehindLatest;
        }

        @Override
        public final Builder millisBehindLatest(Long millisBehindLatest) {
            this.millisBehindLatest = millisBehindLatest;
            return this;
        }

        public final List<ChildShard.Builder> getChildShards() {
            List<ChildShard.Builder> result = ChildShardListCopier.copyToBuilder(this.childShards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChildShards(Collection<ChildShard.BuilderImpl> childShards) {
            this.childShards = ChildShardListCopier.copyFromBuilder(childShards);
        }

        @Override
        public final Builder childShards(Collection<ChildShard> childShards) {
            this.childShards = ChildShardListCopier.copy(childShards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childShards(ChildShard ... childShards) {
            this.childShards(Arrays.asList(childShards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childShards(Consumer<ChildShard.Builder> ... childShards) {
            this.childShards(Stream.of(childShards).map(c -> (ChildShard)((ChildShard.Builder)ChildShard.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SubscribeToShardEvent build() {
            return new SubscribeToShardEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubscribeToShardEvent> {
        public Builder records(Collection<Record> var1);

        public Builder records(Record ... var1);

        public Builder records(Consumer<Record.Builder> ... var1);

        public Builder continuationSequenceNumber(String var1);

        public Builder millisBehindLatest(Long var1);

        public Builder childShards(Collection<ChildShard> var1);

        public Builder childShards(ChildShard ... var1);

        public Builder childShards(Consumer<ChildShard.Builder> ... var1);
    }
}

