/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions;

import java.util.Map;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.PartitionMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.PartitionMetadataProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.Region;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.partitionmetadata.AwsCnPartitionMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.partitionmetadata.AwsIsoBPartitionMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.partitionmetadata.AwsIsoPartitionMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.partitionmetadata.AwsPartitionMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.partitionmetadata.AwsUsGovPartitionMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ImmutableMap;

@SdkPublicApi
public final class GeneratedPartitionMetadataProvider
implements PartitionMetadataProvider {
    private static final Map<String, PartitionMetadata> PARTITION_METADATA = ImmutableMap.builder().put("aws", new AwsPartitionMetadata()).put("aws-cn", (AwsPartitionMetadata)((Object)new AwsCnPartitionMetadata())).put("aws-us-gov", (AwsPartitionMetadata)((Object)new AwsUsGovPartitionMetadata())).put("aws-iso", (AwsPartitionMetadata)((Object)new AwsIsoPartitionMetadata())).put("aws-iso-b", (AwsPartitionMetadata)((Object)new AwsIsoBPartitionMetadata())).build();

    @Override
    public PartitionMetadata partitionMetadata(String partition) {
        return PARTITION_METADATA.get(partition);
    }

    @Override
    public PartitionMetadata partitionMetadata(Region region) {
        return PARTITION_METADATA.values().stream().filter(p -> region.id().matches(p.regionRegex())).findFirst().orElse(new AwsPartitionMetadata());
    }
}

