/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.unmarshall;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkField;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.traits.ListTrait;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.unmarshall.QueryUnmarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.unmarshall.QueryUnmarshallerContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.unmarshall.XmlElement;

@SdkInternalApi
public final class ListQueryUnmarshaller
implements QueryUnmarshaller<List<?>> {
    @Override
    public List<?> unmarshall(QueryUnmarshallerContext context, List<XmlElement> content, SdkField<List<?>> field) {
        ListTrait listTrait = field.getTrait(ListTrait.class);
        ArrayList list = new ArrayList();
        this.getMembers(content, listTrait).forEach(member -> {
            QueryUnmarshaller<Object> unmarshaller = context.getUnmarshaller(listTrait.memberFieldInfo().location(), listTrait.memberFieldInfo().marshallingType());
            list.add(unmarshaller.unmarshall(context, Collections.singletonList(member), listTrait.memberFieldInfo()));
        });
        return list;
    }

    private List<XmlElement> getMembers(List<XmlElement> content, ListTrait listTrait) {
        return listTrait.isFlattened() ? content : content.get(0).children();
    }
}

