/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkProtectedApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.AwsResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.exception.AwsServiceException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkPojo;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.http.HttpResponseHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.http.MetricCollectingHttpResponseHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.metrics.CoreMetric;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.core.ExceptionMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.core.OperationInfo;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.core.ProtocolMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.marshall.QueryProtocolMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.unmarshall.AwsQueryResponseHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.unmarshall.QueryProtocolUnmarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.unmarshall.AwsXmlErrorProtocolUnmarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.unmarshall.XmlElement;

@SdkProtectedApi
public class AwsQueryProtocolFactory {
    private final SdkClientConfiguration clientConfiguration;
    private final List<ExceptionMetadata> modeledExceptions;
    private final Supplier<SdkPojo> defaultServiceExceptionSupplier;
    private final MetricCollectingHttpResponseHandler<AwsServiceException> errorUnmarshaller;

    AwsQueryProtocolFactory(Builder<?> builder) {
        this.clientConfiguration = ((Builder)builder).clientConfiguration;
        this.modeledExceptions = Collections.unmodifiableList(((Builder)builder).modeledExceptions);
        this.defaultServiceExceptionSupplier = ((Builder)builder).defaultServiceExceptionSupplier;
        this.errorUnmarshaller = this.timeUnmarshalling(AwsXmlErrorProtocolUnmarshaller.builder().defaultExceptionSupplier(this.defaultServiceExceptionSupplier).exceptions(this.modeledExceptions).errorUnmarshaller(QueryProtocolUnmarshaller.builder().build()).errorRootExtractor(this::getErrorRoot).build());
    }

    public final ProtocolMarshaller<SdkHttpFullRequest> createProtocolMarshaller(OperationInfo operationInfo) {
        return QueryProtocolMarshaller.builder().endpoint(this.clientConfiguration.option(SdkClientOption.ENDPOINT)).operationInfo(operationInfo).isEc2(this.isEc2()).build();
    }

    public final <T extends AwsResponse> HttpResponseHandler<T> createResponseHandler(Supplier<SdkPojo> pojoSupplier) {
        return this.timeUnmarshalling(new AwsQueryResponseHandler(QueryProtocolUnmarshaller.builder().hasResultWrapper(!this.isEc2()).build(), r -> (SdkPojo)pojoSupplier.get()));
    }

    public final HttpResponseHandler<AwsServiceException> createErrorResponseHandler() {
        return this.errorUnmarshaller;
    }

    private <T> MetricCollectingHttpResponseHandler<T> timeUnmarshalling(HttpResponseHandler<T> delegate) {
        return MetricCollectingHttpResponseHandler.create(CoreMetric.UNMARSHALLING_DURATION, delegate);
    }

    Optional<XmlElement> getErrorRoot(XmlElement document) {
        return document.getOptionalElementByName("Error");
    }

    boolean isEc2() {
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<SubclassT extends Builder> {
        private final List<ExceptionMetadata> modeledExceptions = new ArrayList<ExceptionMetadata>();
        private SdkClientConfiguration clientConfiguration;
        private Supplier<SdkPojo> defaultServiceExceptionSupplier;

        Builder() {
        }

        public final SubclassT clientConfiguration(SdkClientConfiguration clientConfiguration) {
            this.clientConfiguration = clientConfiguration;
            return this.getSubclass();
        }

        public final SubclassT registerModeledException(ExceptionMetadata errorMetadata) {
            this.modeledExceptions.add(errorMetadata);
            return this.getSubclass();
        }

        public final SubclassT defaultServiceExceptionSupplier(Supplier<SdkPojo> exceptionBuilderSupplier) {
            this.defaultServiceExceptionSupplier = exceptionBuilderSupplier;
            return this.getSubclass();
        }

        private SubclassT getSubclass() {
            return (SubclassT)this;
        }

        public AwsQueryProtocolFactory build() {
            return new AwsQueryProtocolFactory(this);
        }
    }
}

