/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal;

import org.apache.flink.kinesis.shaded.io.netty.channel.ChannelHandler;
import org.apache.flink.kinesis.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.kinesis.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.flink.kinesis.shaded.io.netty.handler.codec.http.LastHttpContent;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.utils.NettyClientLogger;

@ChannelHandler.Sharable
@SdkInternalApi
public final class LastHttpContentHandler
extends ChannelInboundHandlerAdapter {
    private static final LastHttpContentHandler INSTANCE = new LastHttpContentHandler();
    private static final NettyClientLogger logger = NettyClientLogger.getLogger(LastHttpContent.class);

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof LastHttpContent) {
            logger.debug(ctx.channel(), () -> "Received LastHttpContent " + ctx.channel());
            ctx.channel().attr(ChannelAttributeKey.LAST_HTTP_CONTENT_RECEIVED_KEY).set(true);
        }
        ctx.fireChannelRead(msg);
    }

    public static LastHttpContentHandler create() {
        return INSTANCE;
    }
}

