/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.stages;

import java.time.Duration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.Response;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.RequestPipeline;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.RequestToResponsePipeline;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.stages.utils.RetryableStageHelper;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.util.MetricUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.metrics.CoreMetric;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.metrics.MetricCollector;

@SdkInternalApi
public final class ApiCallAttemptMetricCollectionStage<OutputT>
implements RequestToResponsePipeline<OutputT> {
    private final RequestPipeline<SdkHttpFullRequest, Response<OutputT>> wrapped;

    public ApiCallAttemptMetricCollectionStage(RequestPipeline<SdkHttpFullRequest, Response<OutputT>> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public Response<OutputT> execute(SdkHttpFullRequest input, RequestExecutionContext context) throws Exception {
        MetricCollector apiCallAttemptMetrics = MetricUtils.createAttemptMetricsCollector(context);
        context.attemptMetricCollector(apiCallAttemptMetrics);
        this.reportBackoffDelay(context);
        Response<OutputT> response = this.wrapped.execute(input, context);
        MetricUtils.collectHttpMetrics(apiCallAttemptMetrics, response.httpResponse());
        return response;
    }

    private void reportBackoffDelay(RequestExecutionContext context) {
        Duration lastBackoffDelay = context.executionAttributes().getAttribute(RetryableStageHelper.LAST_BACKOFF_DELAY_DURATION);
        if (lastBackoffDelay != null) {
            context.attemptMetricCollector().reportMetric(CoreMetric.BACKOFF_DELAY_DURATION, lastBackoffDelay);
        }
    }
}

