/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.params;

import java.time.Clock;
import java.util.Optional;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentials;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.params.SignerChecksumParams;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.Region;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public class Aws4SignerParams {
    private final Boolean doubleUrlEncode;
    private final AwsCredentials awsCredentials;
    private final String signingName;
    private final Region signingRegion;
    private final Integer timeOffset;
    private final Clock signingClockOverride;
    private final SignerChecksumParams checksumParams;

    Aws4SignerParams(BuilderImpl<?> builder) {
        this.doubleUrlEncode = Validate.paramNotNull(((BuilderImpl)builder).doubleUrlEncode, "Double Url encode");
        this.awsCredentials = Validate.paramNotNull(((BuilderImpl)builder).awsCredentials, "Credentials");
        this.signingName = Validate.paramNotNull(((BuilderImpl)builder).signingName, "service signing name");
        this.signingRegion = Validate.paramNotNull(((BuilderImpl)builder).signingRegion, "signing region");
        this.timeOffset = ((BuilderImpl)builder).timeOffset;
        this.signingClockOverride = ((BuilderImpl)builder).signingClockOverride;
        this.checksumParams = ((BuilderImpl)builder).checksumParams;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Boolean doubleUrlEncode() {
        return this.doubleUrlEncode;
    }

    public AwsCredentials awsCredentials() {
        return this.awsCredentials;
    }

    public String signingName() {
        return this.signingName;
    }

    public Region signingRegion() {
        return this.signingRegion;
    }

    public Optional<Integer> timeOffset() {
        return Optional.ofNullable(this.timeOffset);
    }

    public Optional<Clock> signingClockOverride() {
        return Optional.ofNullable(this.signingClockOverride);
    }

    public SignerChecksumParams checksumParams() {
        return this.checksumParams;
    }

    protected static class BuilderImpl<B extends Builder>
    implements Builder<B> {
        private static final Boolean DEFAULT_DOUBLE_URL_ENCODE = Boolean.TRUE;
        private Boolean doubleUrlEncode = DEFAULT_DOUBLE_URL_ENCODE;
        private AwsCredentials awsCredentials;
        private String signingName;
        private Region signingRegion;
        private Integer timeOffset;
        private Clock signingClockOverride;
        private SignerChecksumParams checksumParams;

        protected BuilderImpl() {
        }

        @Override
        public B doubleUrlEncode(Boolean doubleUrlEncode) {
            this.doubleUrlEncode = doubleUrlEncode;
            return (B)this;
        }

        public void setDoubleUrlEncode(Boolean doubleUrlEncode) {
            this.doubleUrlEncode(doubleUrlEncode);
        }

        @Override
        public B awsCredentials(AwsCredentials awsCredentials) {
            this.awsCredentials = awsCredentials;
            return (B)this;
        }

        public void setAwsCredentials(AwsCredentials awsCredentials) {
            this.awsCredentials(awsCredentials);
        }

        @Override
        public B signingName(String signingName) {
            this.signingName = signingName;
            return (B)this;
        }

        public void setSigningName(String signingName) {
            this.signingName(signingName);
        }

        @Override
        public B signingRegion(Region signingRegion) {
            this.signingRegion = signingRegion;
            return (B)this;
        }

        public void setSigningRegion(Region signingRegion) {
            this.signingRegion(signingRegion);
        }

        @Override
        public B timeOffset(Integer timeOffset) {
            this.timeOffset = timeOffset;
            return (B)this;
        }

        public void setTimeOffset(Integer timeOffset) {
            this.timeOffset(timeOffset);
        }

        @Override
        public B signingClockOverride(Clock signingClockOverride) {
            this.signingClockOverride = signingClockOverride;
            return (B)this;
        }

        @Override
        public B checksumParams(SignerChecksumParams checksumParams) {
            this.checksumParams = checksumParams;
            return (B)this;
        }

        public void setSigningClockOverride(Clock signingClockOverride) {
            this.signingClockOverride(signingClockOverride);
        }

        @Override
        public Aws4SignerParams build() {
            return new Aws4SignerParams(this);
        }
    }

    public static interface Builder<B extends Builder> {
        public B doubleUrlEncode(Boolean var1);

        public B awsCredentials(AwsCredentials var1);

        public B signingName(String var1);

        public B signingRegion(Region var1);

        public B timeOffset(Integer var1);

        public B signingClockOverride(Clock var1);

        public B checksumParams(SignerChecksumParams var1);

        public Aws4SignerParams build();
    }
}

