/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkTestInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentials;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.internal.ProfileCredentialsUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.SdkClientException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.profiles.Profile;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.profiles.ProfileFile;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.IoUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.SdkAutoCloseable;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class ProfileCredentialsProvider
implements AwsCredentialsProvider,
SdkAutoCloseable,
ToCopyableBuilder<Builder, ProfileCredentialsProvider> {
    private final AwsCredentialsProvider credentialsProvider;
    private final RuntimeException loadException;
    private final ProfileFile profileFile;
    private final String profileName;
    private final Supplier<ProfileFile> defaultProfileFileLoader;

    private ProfileCredentialsProvider(BuilderImpl builder) {
        AwsCredentialsProvider credentialsProvider = null;
        RuntimeException loadException = null;
        ProfileFile profileFile = null;
        String profileName = null;
        try {
            profileName = builder.profileName != null ? builder.profileName : ProfileFileSystemSetting.AWS_PROFILE.getStringValueOrThrow();
            profileFile = Optional.ofNullable(builder.profileFile).orElseGet(builder.defaultProfileFileLoader);
            String finalProfileName = profileName;
            ProfileFile finalProfileFile = profileFile;
            credentialsProvider = (AwsCredentialsProvider)profileFile.profile(profileName).flatMap(p -> new ProfileCredentialsUtils(finalProfileFile, (Profile)p, finalProfileFile::profile).credentialsProvider()).orElseThrow(() -> {
                String errorMessage = String.format("Profile file contained no credentials for profile '%s': %s", finalProfileName, finalProfileFile);
                return SdkClientException.builder().message(errorMessage).build();
            });
        }
        catch (RuntimeException e) {
            loadException = e;
        }
        this.loadException = loadException;
        this.credentialsProvider = credentialsProvider;
        this.profileFile = profileFile;
        this.profileName = profileName;
        this.defaultProfileFileLoader = builder.defaultProfileFileLoader;
    }

    public static ProfileCredentialsProvider create() {
        return ProfileCredentialsProvider.builder().build();
    }

    public static ProfileCredentialsProvider create(String profileName) {
        return ProfileCredentialsProvider.builder().profileName(profileName).build();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public AwsCredentials resolveCredentials() {
        if (this.loadException != null) {
            throw this.loadException;
        }
        return this.credentialsProvider.resolveCredentials();
    }

    public String toString() {
        return ToString.builder("ProfileCredentialsProvider").add("profileName", this.profileName).add("profileFile", this.profileFile).build();
    }

    @Override
    public void close() {
        IoUtils.closeIfCloseable(this.credentialsProvider, null);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    implements Builder {
        private ProfileFile profileFile;
        private String profileName;
        private Supplier<ProfileFile> defaultProfileFileLoader = ProfileFile::defaultProfileFile;

        BuilderImpl() {
        }

        BuilderImpl(ProfileCredentialsProvider provider) {
            this.profileFile = provider.profileFile;
            this.profileName = provider.profileName;
            this.defaultProfileFileLoader = provider.defaultProfileFileLoader;
        }

        @Override
        public Builder profileFile(ProfileFile profileFile) {
            this.profileFile = profileFile;
            return this;
        }

        public void setProfileFile(ProfileFile profileFile) {
            this.profileFile(profileFile);
        }

        @Override
        public Builder profileFile(Consumer<ProfileFile.Builder> profileFile) {
            return this.profileFile(ProfileFile.builder().applyMutation(profileFile).build());
        }

        @Override
        public Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public void setProfileName(String profileName) {
            this.profileName(profileName);
        }

        @Override
        public ProfileCredentialsProvider build() {
            return new ProfileCredentialsProvider(this);
        }

        @SdkTestInternalApi
        Builder defaultProfileFileLoader(Supplier<ProfileFile> defaultProfileFileLoader) {
            this.defaultProfileFileLoader = defaultProfileFileLoader;
            return this;
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProfileCredentialsProvider> {
        public Builder profileFile(ProfileFile var1);

        public Builder profileFile(Consumer<ProfileFile.Builder> var1);

        public Builder profileName(String var1);

        @Override
        public ProfileCredentialsProvider build();
    }
}

