/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.io.netty.handler.codec.protobuf;

import java.util.List;
import org.apache.flink.kinesis.shaded.com.google.protobuf.nano.MessageNano;
import org.apache.flink.kinesis.shaded.io.netty.buffer.ByteBuf;
import org.apache.flink.kinesis.shaded.io.netty.buffer.ByteBufUtil;
import org.apache.flink.kinesis.shaded.io.netty.channel.ChannelHandler;
import org.apache.flink.kinesis.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.kinesis.shaded.io.netty.handler.codec.MessageToMessageDecoder;
import org.apache.flink.kinesis.shaded.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class ProtobufDecoderNano
extends MessageToMessageDecoder<ByteBuf> {
    private final Class<? extends MessageNano> clazz;

    public ProtobufDecoderNano(Class<? extends MessageNano> clazz) {
        this.clazz = ObjectUtil.checkNotNull(clazz, "You must provide a Class");
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        int offset;
        byte[] array;
        int length = msg.readableBytes();
        if (msg.hasArray()) {
            array = msg.array();
            offset = msg.arrayOffset() + msg.readerIndex();
        } else {
            array = ByteBufUtil.getBytes(msg, msg.readerIndex(), length, false);
            offset = 0;
        }
        MessageNano prototype = this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        out.add(MessageNano.mergeFrom((MessageNano)prototype, (byte[])array, (int)offset, (int)length));
    }
}

