/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.s3.internal.crypto.keywrap;

import org.apache.flink.kinesis.shaded.com.amazonaws.services.s3.internal.crypto.CryptoUtils;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.s3.internal.crypto.keywrap.CipherProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.s3.internal.crypto.keywrap.InternalKeyWrapAlgorithm;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.s3.internal.crypto.keywrap.KeyWrapper;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.s3.internal.crypto.keywrap.KeyWrapperContext;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.s3.internal.crypto.keywrap.KeyWrapperProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.s3.internal.crypto.keywrap.RsaOaepKeyWrapper;

public final class RsaOaepKeyWrapperProvider
implements KeyWrapperProvider {
    private static final RsaOaepKeyWrapperProvider DEFAULT_SHA1 = new RsaOaepKeyWrapperProvider(InternalKeyWrapAlgorithm.RSA_OAEP_SHA1);
    private final InternalKeyWrapAlgorithm cryptoKeyWrapAlgorithm;

    private RsaOaepKeyWrapperProvider(InternalKeyWrapAlgorithm cryptoKeyWrapAlgorithm) {
        this.cryptoKeyWrapAlgorithm = cryptoKeyWrapAlgorithm;
    }

    public static RsaOaepKeyWrapperProvider createSha1() {
        return DEFAULT_SHA1;
    }

    @Override
    public InternalKeyWrapAlgorithm algorithm() {
        return this.cryptoKeyWrapAlgorithm;
    }

    @Override
    public KeyWrapper createKeyWrapper(KeyWrapperContext keyWrapperContext) {
        String remappedCekAlgorithm = CryptoUtils.normalizeContentAlgorithmForValidation(keyWrapperContext.contentCryptoScheme().getCipherAlgorithm());
        return RsaOaepKeyWrapper.builder().cipherProvider(CipherProvider.create(RsaOaepKeyWrapper.cipherAlgorithm(), keyWrapperContext.cryptoProvider())).cryptoKeyWrapAlgorithm(this.cryptoKeyWrapAlgorithm).cekAlgorithm(remappedCekAlgorithm).build();
    }
}

