/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisfirehose.model.transform;

import org.apache.flink.kinesis.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisfirehose.model.ElasticsearchBufferingHints;

@SdkInternalApi
public class ElasticsearchBufferingHintsMarshaller {
    private static final MarshallingInfo<Integer> INTERVALINSECONDS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IntervalInSeconds").build();
    private static final MarshallingInfo<Integer> SIZEINMBS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeInMBs").build();
    private static final ElasticsearchBufferingHintsMarshaller instance = new ElasticsearchBufferingHintsMarshaller();

    public static ElasticsearchBufferingHintsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ElasticsearchBufferingHints elasticsearchBufferingHints, ProtocolMarshaller protocolMarshaller) {
        if (elasticsearchBufferingHints == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(elasticsearchBufferingHints.getIntervalInSeconds(), INTERVALINSECONDS_BINDING);
            protocolMarshaller.marshall(elasticsearchBufferingHints.getSizeInMBs(), SIZEINMBS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

