/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.internal.SdkInternalList;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.StructuredPojo;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.HashKeyRange;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.transform.ChildShardMarshaller;

public class ChildShard
implements Serializable,
Cloneable,
StructuredPojo {
    private String shardId;
    private SdkInternalList<String> parentShards;
    private HashKeyRange hashKeyRange;

    public void setShardId(String shardId) {
        this.shardId = shardId;
    }

    public String getShardId() {
        return this.shardId;
    }

    public ChildShard withShardId(String shardId) {
        this.setShardId(shardId);
        return this;
    }

    public List<String> getParentShards() {
        if (this.parentShards == null) {
            this.parentShards = new SdkInternalList();
        }
        return this.parentShards;
    }

    public void setParentShards(Collection<String> parentShards) {
        if (parentShards == null) {
            this.parentShards = null;
            return;
        }
        this.parentShards = new SdkInternalList<String>(parentShards);
    }

    public ChildShard withParentShards(String ... parentShards) {
        if (this.parentShards == null) {
            this.setParentShards(new SdkInternalList<String>(parentShards.length));
        }
        for (String ele : parentShards) {
            this.parentShards.add(ele);
        }
        return this;
    }

    public ChildShard withParentShards(Collection<String> parentShards) {
        this.setParentShards(parentShards);
        return this;
    }

    public void setHashKeyRange(HashKeyRange hashKeyRange) {
        this.hashKeyRange = hashKeyRange;
    }

    public HashKeyRange getHashKeyRange() {
        return this.hashKeyRange;
    }

    public ChildShard withHashKeyRange(HashKeyRange hashKeyRange) {
        this.setHashKeyRange(hashKeyRange);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getShardId() != null) {
            sb.append("ShardId: ").append(this.getShardId()).append(",");
        }
        if (this.getParentShards() != null) {
            sb.append("ParentShards: ").append(this.getParentShards()).append(",");
        }
        if (this.getHashKeyRange() != null) {
            sb.append("HashKeyRange: ").append(this.getHashKeyRange());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChildShard)) {
            return false;
        }
        ChildShard other = (ChildShard)obj;
        if (other.getShardId() == null ^ this.getShardId() == null) {
            return false;
        }
        if (other.getShardId() != null && !other.getShardId().equals(this.getShardId())) {
            return false;
        }
        if (other.getParentShards() == null ^ this.getParentShards() == null) {
            return false;
        }
        if (other.getParentShards() != null && !other.getParentShards().equals(this.getParentShards())) {
            return false;
        }
        if (other.getHashKeyRange() == null ^ this.getHashKeyRange() == null) {
            return false;
        }
        return other.getHashKeyRange() == null || other.getHashKeyRange().equals(this.getHashKeyRange());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getShardId() == null ? 0 : this.getShardId().hashCode());
        hashCode = 31 * hashCode + (this.getParentShards() == null ? 0 : this.getParentShards().hashCode());
        hashCode = 31 * hashCode + (this.getHashKeyRange() == null ? 0 : this.getHashKeyRange().hashCode());
        return hashCode;
    }

    public ChildShard clone() {
        try {
            return (ChildShard)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ChildShardMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

