/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ConsumerStates;

public enum ShutdownReason {
    ZOMBIE(3, ConsumerStates.ShardConsumerState.SHUTTING_DOWN.getConsumerState()),
    TERMINATE(2, ConsumerStates.ShardConsumerState.SHUTTING_DOWN.getConsumerState()),
    REQUESTED(1, ConsumerStates.ShardConsumerState.SHUTDOWN_REQUESTED.getConsumerState());

    private final int rank;
    private final ConsumerStates.ConsumerState shutdownState;

    private ShutdownReason(int rank, ConsumerStates.ConsumerState shutdownState) {
        this.rank = rank;
        this.shutdownState = shutdownState;
    }

    public boolean canTransitionTo(ShutdownReason reason) {
        if (reason == null) {
            return false;
        }
        return reason.rank > this.rank;
    }

    ConsumerStates.ConsumerState getShutdownState() {
        return this.shutdownState;
    }
}

