/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.transform;

import java.util.Date;
import org.apache.flink.kinesis.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.SSEDescription;

@SdkInternalApi
public class SSEDescriptionMarshaller {
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> SSETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SSEType").build();
    private static final MarshallingInfo<String> KMSMASTERKEYARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KMSMasterKeyArn").build();
    private static final MarshallingInfo<Date> INACCESSIBLEENCRYPTIONDATETIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InaccessibleEncryptionDateTime").timestampFormat("unixTimestamp").build();
    private static final SSEDescriptionMarshaller instance = new SSEDescriptionMarshaller();

    public static SSEDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(SSEDescription sSEDescription, ProtocolMarshaller protocolMarshaller) {
        if (sSEDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(sSEDescription.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(sSEDescription.getSSEType(), SSETYPE_BINDING);
            protocolMarshaller.marshall(sSEDescription.getKMSMasterKeyArn(), KMSMASTERKEYARN_BINDING);
            protocolMarshaller.marshall(sSEDescription.getInaccessibleEncryptionDateTime(), INACCESSIBLEENCRYPTIONDATETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

