/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kinesis.sink;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.StatefulSink;
import org.apache.flink.connector.base.sink.AsyncSinkBase;
import org.apache.flink.connector.base.sink.writer.BufferedRequestState;
import org.apache.flink.connector.base.sink.writer.ElementConverter;
import org.apache.flink.connector.kinesis.sink.KinesisStreamsSinkBuilder;
import org.apache.flink.connector.kinesis.sink.KinesisStreamsSinkWriter;
import org.apache.flink.connector.kinesis.sink.KinesisStreamsStateSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntry;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class KinesisStreamsSink<InputT>
extends AsyncSinkBase<InputT, PutRecordsRequestEntry> {
    private final boolean failOnError;
    private final String streamName;
    private final Properties kinesisClientProperties;

    KinesisStreamsSink(ElementConverter<InputT, PutRecordsRequestEntry> elementConverter, Integer maxBatchSize, Integer maxInFlightRequests, Integer maxBufferedRequests, Long maxBatchSizeInBytes, Long maxTimeInBufferMS, Long maxRecordSizeInBytes, boolean failOnError, String streamName, Properties kinesisClientProperties) {
        super(elementConverter, maxBatchSize, maxInFlightRequests, maxBufferedRequests, maxBatchSizeInBytes, maxTimeInBufferMS, maxRecordSizeInBytes);
        this.streamName = (String)Preconditions.checkNotNull((Object)streamName, (String)"The stream name must not be null when initializing the KDS Sink.");
        Preconditions.checkArgument((!this.streamName.isEmpty() ? 1 : 0) != 0, (Object)"The stream name must be set when initializing the KDS Sink.");
        this.failOnError = failOnError;
        this.kinesisClientProperties = kinesisClientProperties;
    }

    public static <InputT> KinesisStreamsSinkBuilder<InputT> builder() {
        return new KinesisStreamsSinkBuilder();
    }

    @Internal
    public StatefulSink.StatefulSinkWriter<InputT, BufferedRequestState<PutRecordsRequestEntry>> createWriter(Sink.InitContext context) throws IOException {
        return new KinesisStreamsSinkWriter(this.getElementConverter(), context, this.getMaxBatchSize(), this.getMaxInFlightRequests(), this.getMaxBufferedRequests(), this.getMaxBatchSizeInBytes(), this.getMaxTimeInBufferMS(), this.getMaxRecordSizeInBytes(), this.failOnError, this.streamName, this.kinesisClientProperties, Collections.emptyList());
    }

    @Internal
    public SimpleVersionedSerializer<BufferedRequestState<PutRecordsRequestEntry>> getWriterStateSerializer() {
        return new KinesisStreamsStateSerializer();
    }

    @Internal
    public StatefulSink.StatefulSinkWriter<InputT, BufferedRequestState<PutRecordsRequestEntry>> restoreWriter(Sink.InitContext context, Collection<BufferedRequestState<PutRecordsRequestEntry>> recoveredState) throws IOException {
        return new KinesisStreamsSinkWriter(this.getElementConverter(), context, this.getMaxBatchSize(), this.getMaxInFlightRequests(), this.getMaxBufferedRequests(), this.getMaxBatchSizeInBytes(), this.getMaxTimeInBufferMS(), this.getMaxRecordSizeInBytes(), this.failOnError, this.streamName, this.kinesisClientProperties, recoveredState);
    }
}

