/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.hdfs.web.resources.StringParam;

public class AclPermissionParam
extends StringParam {
    public static final String NAME = "aclspec";
    public static final String DEFAULT = "";
    private static final StringParam.Domain DOMAIN = new StringParam.Domain("aclspec", Pattern.compile("^(default:)?(user|group|mask|other):[[A-Za-z_][A-Za-z0-9._-]]*:([rwx-]{3})?(,(default:)?(user|group|mask|other):[[A-Za-z_][A-Za-z0-9._-]]*:([rwx-]{3})?)*$"));

    public AclPermissionParam(String str) {
        super(DOMAIN, str == null || str.equals(DEFAULT) ? null : str);
    }

    public AclPermissionParam(List<AclEntry> acl) {
        super(DOMAIN, AclPermissionParam.parseAclSpec(acl).equals(DEFAULT) ? null : AclPermissionParam.parseAclSpec(acl));
    }

    @Override
    public String getName() {
        return NAME;
    }

    public List<AclEntry> getAclPermission(boolean includePermission) {
        String v = (String)this.getValue();
        return v != null ? AclEntry.parseAclSpec(v, includePermission) : AclEntry.parseAclSpec(DEFAULT, includePermission);
    }

    private static String parseAclSpec(List<AclEntry> aclEntry) {
        return StringUtils.join(aclEntry, (String)",");
    }
}

