/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.util.HostsFileReader;

public class HostFileManager {
    private static final Log LOG = LogFactory.getLog(HostFileManager.class);
    private EntrySet includes = new EntrySet();
    private EntrySet excludes = new EntrySet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String includeFile, String excludeFile) throws IOException {
        MutableEntrySet newIncludes = new MutableEntrySet();
        IOException includeException = null;
        try {
            newIncludes.readFile("included", includeFile);
        }
        catch (IOException e) {
            includeException = e;
        }
        MutableEntrySet newExcludes = new MutableEntrySet();
        IOException excludeException = null;
        try {
            newExcludes.readFile("excluded", excludeFile);
        }
        catch (IOException e) {
            excludeException = e;
        }
        HostFileManager hostFileManager = this;
        synchronized (hostFileManager) {
            if (includeException == null) {
                this.includes = newIncludes;
            }
            if (excludeException == null) {
                this.excludes = newExcludes;
            }
        }
        if (includeException == null) {
            LOG.info((Object)("read includes:\n" + newIncludes));
        } else {
            LOG.error((Object)("failed to read include file '" + includeFile + "'. " + "Continuing to use previous include list."), (Throwable)includeException);
        }
        if (excludeException == null) {
            LOG.info((Object)("read excludes:\n" + newExcludes));
        } else {
            LOG.error((Object)("failed to read exclude file '" + excludeFile + "'." + "Continuing to use previous exclude list."), (Throwable)excludeException);
        }
        if (includeException != null) {
            throw new IOException("error reading hosts file " + includeFile, includeException);
        }
        if (excludeException != null) {
            throw new IOException("error reading exclude file " + excludeFile, excludeException);
        }
    }

    public synchronized boolean isIncluded(DatanodeID dn) {
        if (this.includes.isEmpty()) {
            return true;
        }
        return this.includes.find(dn) != null;
    }

    public synchronized boolean isExcluded(DatanodeID dn) {
        return this.excludes.find(dn) != null;
    }

    public synchronized boolean hasIncludes() {
        return !this.includes.isEmpty();
    }

    public synchronized EntrySet getIncludes() {
        return this.includes;
    }

    public synchronized EntrySet getExcludes() {
        return this.excludes;
    }

    public static class MutableEntrySet
    extends EntrySet {
        public void add(DatanodeID datanodeID) {
            Entry entry = new Entry(datanodeID.getHostName(), datanodeID.getXferPort(), datanodeID.getIpAddr());
            this.index.put(datanodeID.getIpAddr() + ":" + datanodeID.getXferPort(), entry);
        }

        public void add(Entry entry) {
            int port = entry.getPort();
            if (port != 0) {
                this.index.put(entry.getIdentifier() + ":" + port, entry);
            } else {
                this.index.put(entry.getIdentifier(), entry);
            }
        }

        void readFile(String type, String filename) throws IOException {
            if (filename.isEmpty()) {
                return;
            }
            HashSet<String> entrySet = new HashSet<String>();
            HostsFileReader.readFileToSet(type, filename, entrySet);
            for (String str : entrySet) {
                Entry entry = Entry.parse(filename, str);
                this.add(entry);
            }
        }
    }

    public static class EntrySet
    implements Iterable<Entry> {
        final TreeMap<String, Entry> index = new TreeMap();

        public boolean isEmpty() {
            return this.index.isEmpty();
        }

        public Entry find(DatanodeID datanodeID) {
            String registeredHostName;
            Entry entry;
            int xferPort = datanodeID.getXferPort();
            assert (xferPort > 0);
            String datanodeIpAddr = datanodeID.getIpAddr();
            if (datanodeIpAddr != null) {
                entry = this.index.get(datanodeIpAddr + ":" + xferPort);
                if (entry != null) {
                    return entry;
                }
                entry = this.index.get(datanodeIpAddr);
                if (entry != null) {
                    return entry;
                }
            }
            if ((registeredHostName = datanodeID.getHostName()) != null) {
                entry = this.index.get(registeredHostName + ":" + xferPort);
                if (entry != null) {
                    return entry;
                }
                entry = this.index.get(registeredHostName);
                if (entry != null) {
                    return entry;
                }
            }
            return null;
        }

        public Entry find(Entry toFind) {
            int port = toFind.getPort();
            if (port != 0) {
                return this.index.get(toFind.getIdentifier() + ":" + port);
            }
            Map.Entry<String, Entry> ceil = this.index.ceilingEntry(toFind.getIdentifier());
            if (ceil != null && ceil.getValue().getIdentifier().equals(toFind.getIdentifier())) {
                return ceil.getValue();
            }
            return null;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("HostSet(");
            for (Map.Entry<String, Entry> entry : this.index.entrySet()) {
                bld.append("\n\t");
                bld.append(entry.getKey()).append("->").append(entry.getValue().toString());
            }
            bld.append("\n)");
            return bld.toString();
        }

        @Override
        public Iterator<Entry> iterator() {
            return this.index.values().iterator();
        }
    }

    public static class Entry {
        private final String prefix;
        private final int port;
        private final String ipAddress;

        static Entry parse(String fileName, String entry) throws IOException {
            int port;
            String prefix;
            String ipAddress = "";
            int idx = entry.indexOf(58);
            if (-1 == idx) {
                prefix = entry;
                port = 0;
            } else {
                prefix = entry.substring(0, idx);
                String portStr = entry.substring(idx + 1);
                try {
                    port = Integer.valueOf(portStr);
                }
                catch (NumberFormatException e) {
                    throw new IOException("unable to parse port number for '" + entry + "'", e);
                }
            }
            try {
                InetAddress addr = InetAddress.getByName(prefix);
                ipAddress = addr.getHostAddress();
            }
            catch (UnknownHostException e) {
                LOG.info((Object)("When reading " + fileName + ", could not look up " + "IP address for " + prefix + ".  We will assume this is a " + "registration name."), (Throwable)e);
            }
            return new Entry(prefix, port, ipAddress);
        }

        public String getIdentifier() {
            return this.ipAddress.isEmpty() ? this.prefix : this.ipAddress;
        }

        public Entry(String prefix, int port, String ipAddress) {
            this.prefix = prefix;
            this.port = port;
            this.ipAddress = ipAddress;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public int getPort() {
            return this.port;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("Entry{").append(this.prefix).append(", port=").append(this.port).append(", ipAddress=").append(this.ipAddress).append("}");
            return bld.toString();
        }
    }
}

