/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Token;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class NMTokenCache {
    private static final NMTokenCache NM_TOKEN_CACHE = new NMTokenCache();
    private ConcurrentHashMap<String, Token> nmTokens = new ConcurrentHashMap();

    public static NMTokenCache getSingleton() {
        return NM_TOKEN_CACHE;
    }

    @InterfaceAudience.Public
    public static Token getNMToken(String nodeAddr) {
        return NM_TOKEN_CACHE.getToken(nodeAddr);
    }

    @InterfaceAudience.Public
    public static void setNMToken(String nodeAddr, Token token) {
        NM_TOKEN_CACHE.setToken(nodeAddr, token);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public Token getToken(String nodeAddr) {
        return this.nmTokens.get(nodeAddr);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public void setToken(String nodeAddr, Token token) {
        this.nmTokens.put(nodeAddr, token);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public boolean containsToken(String nodeAddr) {
        return this.nmTokens.containsKey(nodeAddr);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public int numberOfTokensInCache() {
        return this.nmTokens.size();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void removeToken(String nodeAddr) {
        this.nmTokens.remove(nodeAddr);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void clearCache() {
        this.nmTokens.clear();
    }
}

