/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.BlockReaderLocal;
import org.apache.hadoop.hdfs.BlockReaderLocalLegacy;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DomainSocketFactory;
import org.apache.hadoop.hdfs.FileInputStreamCache;
import org.apache.hadoop.hdfs.PeerCache;
import org.apache.hadoop.hdfs.RemoteBlockReader;
import org.apache.hadoop.hdfs.RemoteBlockReader2;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
public class BlockReaderFactory {
    public static BlockReader newBlockReader(DFSClient.Conf conf, String file, ExtendedBlock block, Token<BlockTokenIdentifier> blockToken, long startOffset, long len, boolean verifyChecksum, String clientName, Peer peer, DatanodeID datanodeID, DomainSocketFactory domSockFactory, PeerCache peerCache, FileInputStreamCache fisCache, boolean allowShortCircuitLocalReads, CachingStrategy cachingStrategy) throws IOException {
        BlockReader reader;
        peer.setReadTimeout(conf.socketTimeout);
        peer.setWriteTimeout(HdfsServerConstants.WRITE_TIMEOUT);
        if (peer.getDomainSocket() != null) {
            if (allowShortCircuitLocalReads && !conf.useLegacyBlockReaderLocal && (reader = BlockReaderFactory.newShortCircuitBlockReader(conf, file, block, blockToken, startOffset, len, peer, datanodeID, domSockFactory, verifyChecksum, fisCache, cachingStrategy)) != null) {
                if (peerCache != null) {
                    peerCache.put(datanodeID, peer);
                } else {
                    IOUtils.cleanup(null, peer);
                }
                return reader;
            }
            if (!conf.domainSocketDataTraffic) {
                throw new IOException("Because we can't do short-circuit access, and data traffic over domain sockets is disabled, we cannot use this socket to talk to " + datanodeID);
            }
        }
        if (conf.useLegacyBlockReader) {
            reader = RemoteBlockReader.newBlockReader(file, block, blockToken, startOffset, len, conf.ioBufferSize, verifyChecksum, clientName, peer, datanodeID, peerCache, cachingStrategy);
            return reader;
        }
        return RemoteBlockReader2.newBlockReader(file, block, blockToken, startOffset, len, verifyChecksum, clientName, peer, datanodeID, peerCache, cachingStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static BlockReaderLocal newShortCircuitBlockReader(DFSClient.Conf conf, String file, ExtendedBlock block, Token<BlockTokenIdentifier> blockToken, long startOffset, long len, Peer peer, DatanodeID datanodeID, DomainSocketFactory domSockFactory, boolean verifyChecksum, FileInputStreamCache fisCache, CachingStrategy cachingStrategy) throws IOException {
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(peer.getOutputStream()));
        new Sender(out).requestShortCircuitFds(block, blockToken, 1);
        DataInputStream in = new DataInputStream(peer.getInputStream());
        DataTransferProtos.BlockOpResponseProto resp = DataTransferProtos.BlockOpResponseProto.parseFrom(PBHelper.vintPrefixed(in));
        DomainSocket sock = peer.getDomainSocket();
        switch (resp.getStatus()) {
            case SUCCESS: {
                BlockReaderLocal reader = null;
                byte[] buf = new byte[1];
                FileInputStream[] fis = new FileInputStream[2];
                sock.recvFileInputStreams(fis, buf, 0, buf.length);
                try {
                    reader = new BlockReaderLocal.Builder(conf).setFilename(file).setBlock(block).setStartOffset(startOffset).setStreams(fis).setDatanodeID(datanodeID).setVerifyChecksum(verifyChecksum).setBlockMetadataHeader(BlockMetadataHeader.preadHeader(fis[1].getChannel())).setFileInputStreamCache(fisCache).setCachingStrategy(cachingStrategy).build();
                    if (reader != null) return reader;
                }
                catch (Throwable throwable) {
                    if (reader != null) throw throwable;
                    IOUtils.cleanup(DFSClient.LOG, fis[0], fis[1]);
                    throw throwable;
                }
                IOUtils.cleanup(DFSClient.LOG, fis[0], fis[1]);
                return reader;
            }
            case ERROR_UNSUPPORTED: {
                if (!resp.hasShortCircuitAccessVersion()) {
                    DFSClient.LOG.warn((Object)("short-circuit read access is disabled for DataNode " + datanodeID + ".  reason: " + resp.getMessage()));
                    domSockFactory.disableShortCircuitForPath(sock.getPath());
                    return null;
                } else {
                    DFSClient.LOG.warn((Object)("short-circuit read access for the file " + file + " is disabled for DataNode " + datanodeID + ".  reason: " + resp.getMessage()));
                }
                return null;
            }
            case ERROR_ACCESS_TOKEN: {
                String msg = "access control error while attempting to set up short-circuit access to " + file + resp.getMessage();
                DFSClient.LOG.debug((Object)msg);
                throw new InvalidBlockTokenException(msg);
            }
        }
        DFSClient.LOG.warn((Object)("error while attempting to set up short-circuit access to " + file + ": " + resp.getMessage()));
        domSockFactory.disableShortCircuitForPath(sock.getPath());
        return null;
    }

    public static String getFileName(InetSocketAddress s, String poolId, long blockId) {
        return s.toString() + ":" + poolId + ":" + blockId;
    }

    static BlockReader getLegacyBlockReaderLocal(DFSClient dfsClient, String src, ExtendedBlock blk, Token<BlockTokenIdentifier> accessToken, DatanodeInfo chosenNode, long offsetIntoBlock) throws SecretManager.InvalidToken, IOException {
        try {
            long length = blk.getNumBytes() - offsetIntoBlock;
            return BlockReaderLocalLegacy.newBlockReader(dfsClient, src, blk, accessToken, chosenNode, offsetIntoBlock, length);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(SecretManager.InvalidToken.class, AccessControlException.class);
        }
    }
}

