/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hadoop.shaded.org.apache.http.impl.client;

import org.apache.flink.hadoop.shaded.org.apache.http.HeaderElement;
import org.apache.flink.hadoop.shaded.org.apache.http.HttpResponse;
import org.apache.flink.hadoop.shaded.org.apache.http.annotation.Immutable;
import org.apache.flink.hadoop.shaded.org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.flink.hadoop.shaded.org.apache.http.message.BasicHeaderElementIterator;
import org.apache.flink.hadoop.shaded.org.apache.http.protocol.HttpContext;

@Immutable
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

