/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.net.BasicInetPeer;
import org.apache.hadoop.hdfs.net.EncryptedPeer;
import org.apache.hadoop.hdfs.net.NioInetPeer;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.net.PeerServer;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.server.datanode.SecureDataNodeStarter;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.Server;

@InterfaceAudience.Private
public class TcpPeerServer
implements PeerServer {
    static Log LOG = LogFactory.getLog(TcpPeerServer.class);
    private final ServerSocket serverSocket;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Peer peerFromSocket(Socket socket) throws IOException {
        Peer peer = null;
        boolean success = false;
        try {
            socket.setTcpNoDelay(true);
            SocketChannel channel = socket.getChannel();
            peer = channel == null ? new BasicInetPeer(socket) : new NioInetPeer(socket);
            success = true;
            Peer peer2 = peer;
            return peer2;
        }
        finally {
            if (!success) {
                if (peer != null) {
                    peer.close();
                }
                socket.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Peer peerFromSocketAndKey(Socket s, DataEncryptionKey key) throws IOException {
        Peer peer;
        block4: {
            Peer peer2 = null;
            boolean success = false;
            try {
                peer2 = TcpPeerServer.peerFromSocket(s);
                if (key != null) {
                    peer2 = new EncryptedPeer(peer2, key);
                }
                success = true;
                peer = peer2;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.cleanup(null, peer2);
                }
                throw throwable;
            }
            IOUtils.cleanup(null, peer2);
        }
        return peer;
    }

    public TcpPeerServer(int socketWriteTimeout, InetSocketAddress bindAddr) throws IOException {
        this.serverSocket = socketWriteTimeout > 0 ? ServerSocketChannel.open().socket() : new ServerSocket();
        Server.bind(this.serverSocket, bindAddr, 0);
    }

    public TcpPeerServer(SecureDataNodeStarter.SecureResources secureResources) {
        this.serverSocket = secureResources.getStreamingSocket();
    }

    public InetSocketAddress getStreamingAddr() {
        return new InetSocketAddress(this.serverSocket.getInetAddress().getHostAddress(), this.serverSocket.getLocalPort());
    }

    @Override
    public void setReceiveBufferSize(int size) throws IOException {
        this.serverSocket.setReceiveBufferSize(size);
    }

    @Override
    public Peer accept() throws IOException, SocketTimeoutException {
        Peer peer = TcpPeerServer.peerFromSocket(this.serverSocket.accept());
        return peer;
    }

    @Override
    public String getListeningString() {
        return this.serverSocket.getLocalSocketAddress().toString();
    }

    @Override
    public void close() throws IOException {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            LOG.error((Object)"error closing TcpPeerServer: ", (Throwable)e);
        }
    }

    public String toString() {
        return "TcpPeerServer(" + this.getListeningString() + ")";
    }
}

