/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.flink.hadoop.shaded.com.google.protobuf.TextFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerLaunchContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.PriorityPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ApplicationSubmissionContextPBImpl
extends ApplicationSubmissionContext {
    YarnProtos.ApplicationSubmissionContextProto proto = YarnProtos.ApplicationSubmissionContextProto.getDefaultInstance();
    YarnProtos.ApplicationSubmissionContextProto.Builder builder = null;
    boolean viaProto = false;
    private ApplicationId applicationId = null;
    private Priority priority = null;
    private ContainerLaunchContext amContainer = null;
    private Resource resource = null;

    public ApplicationSubmissionContextPBImpl() {
        this.builder = YarnProtos.ApplicationSubmissionContextProto.newBuilder();
    }

    public ApplicationSubmissionContextPBImpl(YarnProtos.ApplicationSubmissionContextProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ApplicationSubmissionContextProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((ApplicationSubmissionContextPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString(this.getProto());
    }

    private void mergeLocalToBuilder() {
        if (this.applicationId != null) {
            this.builder.setApplicationId(this.convertToProtoFormat(this.applicationId));
        }
        if (this.priority != null) {
            this.builder.setPriority(this.convertToProtoFormat(this.priority));
        }
        if (this.amContainer != null) {
            this.builder.setAmContainerSpec(this.convertToProtoFormat(this.amContainer));
        }
        if (this.resource != null && !((ResourcePBImpl)this.resource).getProto().equals(this.builder.getResource())) {
            this.builder.setResource(this.convertToProtoFormat(this.resource));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ApplicationSubmissionContextProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public Priority getPriority() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p;
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder applicationSubmissionContextProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.priority != null) {
            return this.priority;
        }
        if (!p.hasPriority()) {
            return null;
        }
        this.priority = this.convertFromProtoFormat(p.getPriority());
        return this.priority;
    }

    @Override
    public void setPriority(Priority priority) {
        this.maybeInitBuilder();
        if (priority == null) {
            this.builder.clearPriority();
        }
        this.priority = priority;
    }

    @Override
    public ApplicationId getApplicationId() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p;
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder applicationSubmissionContextProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.applicationId != null) {
            return this.applicationId;
        }
        if (!p.hasApplicationId()) {
            return null;
        }
        this.applicationId = this.convertFromProtoFormat(p.getApplicationId());
        return this.applicationId;
    }

    @Override
    public void setApplicationId(ApplicationId applicationId) {
        this.maybeInitBuilder();
        if (applicationId == null) {
            this.builder.clearApplicationId();
        }
        this.applicationId = applicationId;
    }

    @Override
    public String getApplicationName() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p;
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder applicationSubmissionContextProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasApplicationName()) {
            return null;
        }
        return p.getApplicationName();
    }

    @Override
    public void setApplicationName(String applicationName) {
        this.maybeInitBuilder();
        if (applicationName == null) {
            this.builder.clearApplicationName();
            return;
        }
        this.builder.setApplicationName(applicationName);
    }

    @Override
    public String getQueue() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p;
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder applicationSubmissionContextProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasQueue()) {
            return null;
        }
        return p.getQueue();
    }

    @Override
    public String getApplicationType() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p;
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder applicationSubmissionContextProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasApplicationType()) {
            return null;
        }
        return p.getApplicationType();
    }

    @Override
    public void setQueue(String queue) {
        this.maybeInitBuilder();
        if (queue == null) {
            this.builder.clearQueue();
            return;
        }
        this.builder.setQueue(queue);
    }

    @Override
    public void setApplicationType(String applicationType) {
        this.maybeInitBuilder();
        if (applicationType == null) {
            this.builder.clearApplicationType();
            return;
        }
        this.builder.setApplicationType(applicationType);
    }

    @Override
    public ContainerLaunchContext getAMContainerSpec() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p;
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder applicationSubmissionContextProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.amContainer != null) {
            return this.amContainer;
        }
        if (!p.hasAmContainerSpec()) {
            return null;
        }
        this.amContainer = this.convertFromProtoFormat(p.getAmContainerSpec());
        return this.amContainer;
    }

    @Override
    public void setAMContainerSpec(ContainerLaunchContext amContainer) {
        this.maybeInitBuilder();
        if (amContainer == null) {
            this.builder.clearAmContainerSpec();
        }
        this.amContainer = amContainer;
    }

    @Override
    public boolean getUnmanagedAM() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getUnmanagedAm();
    }

    @Override
    public void setUnmanagedAM(boolean value) {
        this.maybeInitBuilder();
        this.builder.setUnmanagedAm(value);
    }

    @Override
    public boolean getCancelTokensWhenComplete() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getCancelTokensWhenComplete();
    }

    @Override
    public void setCancelTokensWhenComplete(boolean cancel) {
        this.maybeInitBuilder();
        this.builder.setCancelTokensWhenComplete(cancel);
    }

    @Override
    public int getMaxAppAttempts() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getMaxAppAttempts();
    }

    @Override
    public void setMaxAppAttempts(int maxAppAttempts) {
        this.maybeInitBuilder();
        this.builder.setMaxAppAttempts(maxAppAttempts);
    }

    @Override
    public Resource getResource() {
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder p;
        YarnProtos.ApplicationSubmissionContextProtoOrBuilder applicationSubmissionContextProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.resource != null) {
            return this.resource;
        }
        if (!p.hasResource()) {
            return null;
        }
        this.resource = this.convertFromProtoFormat(p.getResource());
        return this.resource;
    }

    @Override
    public void setResource(Resource resource) {
        this.maybeInitBuilder();
        if (resource == null) {
            this.builder.clearResource();
        }
        this.resource = resource;
    }

    private PriorityPBImpl convertFromProtoFormat(YarnProtos.PriorityProto p) {
        return new PriorityPBImpl(p);
    }

    private YarnProtos.PriorityProto convertToProtoFormat(Priority t) {
        return ((PriorityPBImpl)t).getProto();
    }

    private ApplicationIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationIdProto p) {
        return new ApplicationIdPBImpl(p);
    }

    private YarnProtos.ApplicationIdProto convertToProtoFormat(ApplicationId t) {
        return ((ApplicationIdPBImpl)t).getProto();
    }

    private ContainerLaunchContextPBImpl convertFromProtoFormat(YarnProtos.ContainerLaunchContextProto p) {
        return new ContainerLaunchContextPBImpl(p);
    }

    private YarnProtos.ContainerLaunchContextProto convertToProtoFormat(ContainerLaunchContext t) {
        return ((ContainerLaunchContextPBImpl)t).getProto();
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource t) {
        return ((ResourcePBImpl)t).getProto();
    }
}

