/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.bzip2;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.compress.Decompressor;

public class Bzip2Decompressor
implements Decompressor {
    private static final int DEFAULT_DIRECT_BUFFER_SIZE = 65536;
    private static final Log LOG = LogFactory.getLog(Bzip2Decompressor.class);
    private static Class<Bzip2Decompressor> clazz = Bzip2Decompressor.class;
    private long stream;
    private boolean conserveMemory;
    private int directBufferSize;
    private Buffer compressedDirectBuf = null;
    private int compressedDirectBufOff;
    private int compressedDirectBufLen;
    private Buffer uncompressedDirectBuf = null;
    private byte[] userBuf = null;
    private int userBufOff = 0;
    private int userBufLen = 0;
    private boolean finished;

    public Bzip2Decompressor(boolean conserveMemory, int directBufferSize) {
        this.conserveMemory = conserveMemory;
        this.directBufferSize = directBufferSize;
        this.compressedDirectBuf = ByteBuffer.allocateDirect(directBufferSize);
        this.uncompressedDirectBuf = ByteBuffer.allocateDirect(directBufferSize);
        this.uncompressedDirectBuf.position(directBufferSize);
        this.stream = Bzip2Decompressor.init(conserveMemory ? 1 : 0);
    }

    public Bzip2Decompressor() {
        this(false, 65536);
    }

    @Override
    public synchronized void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.userBuf = b;
        this.userBufOff = off;
        this.userBufLen = len;
        this.setInputFromSavedData();
        this.uncompressedDirectBuf.limit(this.directBufferSize);
        this.uncompressedDirectBuf.position(this.directBufferSize);
    }

    synchronized void setInputFromSavedData() {
        this.compressedDirectBufOff = 0;
        this.compressedDirectBufLen = this.userBufLen;
        if (this.compressedDirectBufLen > this.directBufferSize) {
            this.compressedDirectBufLen = this.directBufferSize;
        }
        this.compressedDirectBuf.rewind();
        ((ByteBuffer)this.compressedDirectBuf).put(this.userBuf, this.userBufOff, this.compressedDirectBufLen);
        this.userBufOff += this.compressedDirectBufLen;
        this.userBufLen -= this.compressedDirectBufLen;
    }

    @Override
    public synchronized void setDictionary(byte[] b, int off, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean needsInput() {
        if (this.uncompressedDirectBuf.remaining() > 0) {
            return false;
        }
        if (this.compressedDirectBufLen <= 0) {
            if (this.userBufLen <= 0) {
                return true;
            }
            this.setInputFromSavedData();
        }
        return false;
    }

    @Override
    public synchronized boolean needsDictionary() {
        return false;
    }

    @Override
    public synchronized boolean finished() {
        return this.finished && this.uncompressedDirectBuf.remaining() == 0;
    }

    @Override
    public synchronized int decompress(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n = this.uncompressedDirectBuf.remaining();
        if (n > 0) {
            n = Math.min(n, len);
            ((ByteBuffer)this.uncompressedDirectBuf).get(b, off, n);
            return n;
        }
        this.uncompressedDirectBuf.rewind();
        this.uncompressedDirectBuf.limit(this.directBufferSize);
        n = this.finished ? 0 : this.inflateBytesDirect();
        this.uncompressedDirectBuf.limit(n);
        n = Math.min(n, len);
        ((ByteBuffer)this.uncompressedDirectBuf).get(b, off, n);
        return n;
    }

    public synchronized long getBytesWritten() {
        this.checkStream();
        return Bzip2Decompressor.getBytesWritten(this.stream);
    }

    public synchronized long getBytesRead() {
        this.checkStream();
        return Bzip2Decompressor.getBytesRead(this.stream);
    }

    @Override
    public synchronized int getRemaining() {
        this.checkStream();
        return this.userBufLen + Bzip2Decompressor.getRemaining(this.stream);
    }

    @Override
    public synchronized void reset() {
        this.checkStream();
        Bzip2Decompressor.end(this.stream);
        this.stream = Bzip2Decompressor.init(this.conserveMemory ? 1 : 0);
        this.finished = false;
        this.compressedDirectBufLen = 0;
        this.compressedDirectBufOff = 0;
        this.uncompressedDirectBuf.limit(this.directBufferSize);
        this.uncompressedDirectBuf.position(this.directBufferSize);
        this.userBufLen = 0;
        this.userBufOff = 0;
    }

    @Override
    public synchronized void end() {
        if (this.stream != 0L) {
            Bzip2Decompressor.end(this.stream);
            this.stream = 0L;
        }
    }

    static void initSymbols(String libname) {
        Bzip2Decompressor.initIDs(libname);
    }

    private void checkStream() {
        if (this.stream == 0L) {
            throw new NullPointerException();
        }
    }

    private static native void initIDs(String var0);

    private static native long init(int var0);

    private native int inflateBytesDirect();

    private static native long getBytesRead(long var0);

    private static native long getBytesWritten(long var0);

    private static native int getRemaining(long var0);

    private static native void end(long var0);
}

