/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.PathIsNotDirectoryException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LayoutFlags;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageCompression;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryWithQuota;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SaveNamespaceContext;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectorySnapshottable;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectoryWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeFileUnderConstructionWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeFileWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotFSImageFormat;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Step;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StepType;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FSImageFormat {
    private static final Log LOG = FSImage.LOG;

    private FSImageFormat() {
    }

    static class Saver {
        private final SaveNamespaceContext context;
        private boolean saved = false;
        private MD5Hash savedDigest;
        private final SnapshotFSImageFormat.ReferenceMap referenceMap = new SnapshotFSImageFormat.ReferenceMap();
        private final Map<Long, INodeFileUnderConstruction> snapshotUCMap = new HashMap<Long, INodeFileUnderConstruction>();

        private void checkSaved() {
            if (!this.saved) {
                throw new IllegalStateException("FSImageSaver has not saved an image");
            }
        }

        private void checkNotSaved() {
            if (this.saved) {
                throw new IllegalStateException("FSImageSaver has already saved an image");
            }
        }

        Saver(SaveNamespaceContext context) {
            this.context = context;
        }

        MD5Hash getSavedDigest() {
            this.checkSaved();
            return this.savedDigest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void save(File newFile, FSImageCompression compression) throws IOException {
            this.checkNotSaved();
            FSNamesystem sourceNamesystem = this.context.getSourceNamesystem();
            FSDirectory fsDir = sourceNamesystem.dir;
            String sdPath = newFile.getParentFile().getParentFile().getAbsolutePath();
            Step step = new Step(StepType.INODES, sdPath);
            StartupProgress prog = NameNode.getStartupProgress();
            prog.beginStep(Phase.SAVING_CHECKPOINT, step);
            prog.setTotal(Phase.SAVING_CHECKPOINT, step, fsDir.rootDir.numItemsInTree());
            StartupProgress.Counter counter = prog.getCounter(Phase.SAVING_CHECKPOINT, step);
            long startTime = Time.now();
            MessageDigest digester = MD5Hash.getDigester();
            FileOutputStream fout = new FileOutputStream(newFile);
            DigestOutputStream fos = new DigestOutputStream(fout, digester);
            DataOutputStream out = new DataOutputStream(fos);
            try {
                out.writeInt(HdfsConstants.LAYOUT_VERSION);
                LayoutFlags.write(out);
                out.writeInt(sourceNamesystem.unprotectedGetNamespaceInfo().getNamespaceID());
                out.writeLong(fsDir.rootDir.numItemsInTree());
                out.writeLong(sourceNamesystem.getGenerationStampV1());
                out.writeLong(sourceNamesystem.getGenerationStampV2());
                out.writeLong(sourceNamesystem.getGenerationStampAtblockIdSwitch());
                out.writeLong(sourceNamesystem.getLastAllocatedBlockId());
                out.writeLong(this.context.getTxId());
                out.writeLong(sourceNamesystem.getLastInodeId());
                sourceNamesystem.getSnapshotManager().write(out);
                out = compression.writeHeaderAndWrapStream(fos);
                LOG.info((Object)("Saving image file " + newFile + " using " + compression));
                this.saveINode2Image(fsDir.rootDir, out, false, this.referenceMap, counter);
                this.saveImage(fsDir.rootDir, out, true, false, counter);
                prog.endStep(Phase.SAVING_CHECKPOINT, step);
                prog.setCount(Phase.SAVING_CHECKPOINT, step, fsDir.rootDir.numItemsInTree());
                sourceNamesystem.saveFilesUnderConstruction(out, this.snapshotUCMap);
                this.context.checkCancelled();
                sourceNamesystem.saveSecretManagerState(out, sdPath);
                this.context.checkCancelled();
                sourceNamesystem.getCacheManager().saveState(out, sdPath);
                this.context.checkCancelled();
                out.flush();
                this.context.checkCancelled();
                fout.getChannel().force(true);
            }
            finally {
                out.close();
            }
            this.saved = true;
            this.savedDigest = new MD5Hash(digester.digest());
            LOG.info((Object)("Image file " + newFile + " of size " + newFile.length() + " bytes saved in " + (Time.now() - startTime) / 1000L + " seconds."));
        }

        private int saveChildren(ReadOnlyList<INode> children, DataOutputStream out, boolean inSnapshot, StartupProgress.Counter counter) throws IOException {
            out.writeInt(children.size());
            int dirNum = 0;
            int i = 0;
            for (INode child : children) {
                this.saveINode2Image(child, out, false, this.referenceMap, counter);
                if (child.isDirectory()) {
                    ++dirNum;
                } else if (inSnapshot && child.isFile() && child.asFile().isUnderConstruction()) {
                    this.snapshotUCMap.put(child.getId(), (INodeFileUnderConstruction)child.asFile());
                }
                if (i++ % 50 != 0) continue;
                this.context.checkCancelled();
            }
            return dirNum;
        }

        private void saveImage(INodeDirectory current, DataOutputStream out, boolean toSaveSubtree, boolean inSnapshot, StartupProgress.Counter counter) throws IOException {
            boolean toSave;
            out.writeLong(current.getId());
            if (!toSaveSubtree) {
                return;
            }
            ReadOnlyList<INode> children = current.getChildrenList(null);
            int dirNum = 0;
            ArrayList<INodeDirectory> snapshotDirs = null;
            if (current instanceof INodeDirectoryWithSnapshot) {
                snapshotDirs = new ArrayList<INodeDirectory>();
                ((INodeDirectoryWithSnapshot)current).getSnapshotDirectory(snapshotDirs);
                dirNum += snapshotDirs.size();
            }
            if (current instanceof INodeDirectorySnapshottable) {
                INodeDirectorySnapshottable snapshottableNode = (INodeDirectorySnapshottable)current;
                SnapshotFSImageFormat.saveSnapshots(snapshottableNode, out);
            } else {
                out.writeInt(-1);
            }
            SnapshotFSImageFormat.saveDirectoryDiffList(current, out, this.referenceMap);
            out.writeInt(dirNum += this.saveChildren(children, out, inSnapshot, counter));
            for (INode child : children) {
                if (!child.isDirectory()) continue;
                toSave = child.isReference() ? this.referenceMap.toProcessSubtree(child.getId()) : true;
                this.saveImage(child.asDirectory(), out, toSave, inSnapshot, counter);
            }
            if (snapshotDirs != null) {
                for (INodeDirectory subDir : snapshotDirs) {
                    toSave = subDir.getParentReference() != null ? this.referenceMap.toProcessSubtree(subDir.getId()) : true;
                    this.saveImage(subDir, out, toSave, true, counter);
                }
            }
        }

        private void saveINode2Image(INode inode, DataOutputStream out, boolean writeUnderConstruction, SnapshotFSImageFormat.ReferenceMap referenceMap, StartupProgress.Counter counter) throws IOException {
            FSImageSerialization.saveINode2Image(inode, out, writeUnderConstruction, referenceMap);
            if (!(inode instanceof INodeReference)) {
                counter.increment();
            }
        }
    }

    public static class Loader {
        private final Configuration conf;
        private final FSNamesystem namesystem;
        private boolean loaded = false;
        private long imgTxId;
        private MD5Hash imgDigest;
        private Map<Integer, Snapshot> snapshotMap = null;
        private final SnapshotFSImageFormat.ReferenceMap referenceMap = new SnapshotFSImageFormat.ReferenceMap();

        Loader(Configuration conf, FSNamesystem namesystem) {
            this.conf = conf;
            this.namesystem = namesystem;
        }

        MD5Hash getLoadedImageMd5() {
            this.checkLoaded();
            return this.imgDigest;
        }

        long getLoadedImageTxId() {
            this.checkLoaded();
            return this.imgTxId;
        }

        private void checkLoaded() {
            if (!this.loaded) {
                throw new IllegalStateException("Image not yet loaded!");
            }
        }

        private void checkNotLoaded() {
            if (this.loaded) {
                throw new IllegalStateException("Image already loaded!");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void load(File curFile) throws IOException {
            this.checkNotLoaded();
            assert (curFile != null) : "curFile is null";
            StartupProgress prog = NameNode.getStartupProgress();
            Step step = new Step(StepType.INODES);
            prog.beginStep(Phase.LOADING_FSIMAGE, step);
            long startTime = Time.now();
            MessageDigest digester = MD5Hash.getDigester();
            DigestInputStream fin = new DigestInputStream(new FileInputStream(curFile), digester);
            DataInputStream in = new DataInputStream(fin);
            try {
                boolean eof;
                int imgVersion = in.readInt();
                if (this.getLayoutVersion() != imgVersion) {
                    throw new InconsistentFSStateException(curFile, "imgVersion " + imgVersion + " expected to be " + this.getLayoutVersion());
                }
                boolean supportSnapshot = LayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, imgVersion);
                if (LayoutVersion.supports(LayoutVersion.Feature.ADD_LAYOUT_FLAGS, imgVersion)) {
                    LayoutFlags.read(in);
                }
                in.readInt();
                long numFiles = in.readLong();
                long genstamp = in.readLong();
                this.namesystem.setGenerationStampV1(genstamp);
                if (LayoutVersion.supports(LayoutVersion.Feature.SEQUENTIAL_BLOCK_ID, imgVersion)) {
                    genstamp = in.readLong();
                    this.namesystem.setGenerationStampV2(genstamp);
                    long stampAtIdSwitch = in.readLong();
                    this.namesystem.setGenerationStampV1Limit(stampAtIdSwitch);
                    long maxSequentialBlockId = in.readLong();
                    this.namesystem.setLastAllocatedBlockId(maxSequentialBlockId);
                } else {
                    long startingGenStamp = this.namesystem.upgradeGenerationStampToV2();
                    LOG.info((Object)("Upgrading to sequential block IDs. Generation stamp for new blocks set to " + startingGenStamp));
                }
                this.imgTxId = LayoutVersion.supports(LayoutVersion.Feature.STORED_TXIDS, imgVersion) ? in.readLong() : 0L;
                if (LayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, imgVersion)) {
                    long lastInodeId = in.readLong();
                    this.namesystem.resetLastInodeId(lastInodeId);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("load last allocated InodeId from fsimage:" + lastInodeId));
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Old layout version doesn't have inode id. Will assign new id for each inode.");
                }
                if (supportSnapshot) {
                    this.snapshotMap = this.namesystem.getSnapshotManager().read(in, this);
                }
                FSImageCompression compression = LayoutVersion.supports(LayoutVersion.Feature.FSIMAGE_COMPRESSION, imgVersion) ? FSImageCompression.readCompressionHeader(this.conf, in) : FSImageCompression.createNoopCompression();
                in = compression.unwrapInputStream(fin);
                LOG.info((Object)("Loading image file " + curFile + " using " + compression));
                LOG.info((Object)("Number of files = " + numFiles));
                prog.setTotal(Phase.LOADING_FSIMAGE, step, numFiles);
                StartupProgress.Counter counter = prog.getCounter(Phase.LOADING_FSIMAGE, step);
                if (LayoutVersion.supports(LayoutVersion.Feature.FSIMAGE_NAME_OPTIMIZATION, imgVersion)) {
                    if (supportSnapshot) {
                        this.loadLocalNameINodesWithSnapshot(numFiles, in, counter);
                    } else {
                        this.loadLocalNameINodes(numFiles, in, counter);
                    }
                } else {
                    this.loadFullNameINodes(numFiles, in, counter);
                }
                this.loadFilesUnderConstruction(in, supportSnapshot, counter);
                prog.endStep(Phase.LOADING_FSIMAGE, step);
                prog.setCount(Phase.LOADING_FSIMAGE, step, numFiles);
                this.loadSecretManagerState(in);
                this.loadCacheManagerState(in);
                boolean bl = eof = in.read() == -1;
                assert (eof) : "Should have reached the end of image file " + curFile;
            }
            finally {
                in.close();
            }
            this.imgDigest = new MD5Hash(digester.digest());
            this.loaded = true;
            LOG.info((Object)("Image file " + curFile + " of size " + curFile.length() + " bytes loaded in " + (Time.now() - startTime) / 1000L + " seconds."));
        }

        private void updateRootAttr(INodeWithAdditionalFields root) {
            long nsQuota = root.getNsQuota();
            long dsQuota = root.getDsQuota();
            FSDirectory fsDir = this.namesystem.dir;
            if (nsQuota != -1L || dsQuota != -1L) {
                fsDir.rootDir.setQuota(nsQuota, dsQuota);
            }
            fsDir.rootDir.cloneModificationTime(root);
            fsDir.rootDir.clonePermissionStatus(root);
        }

        private void loadLocalNameINodesWithSnapshot(long numFiles, DataInput in, StartupProgress.Counter counter) throws IOException {
            assert (LayoutVersion.supports(LayoutVersion.Feature.FSIMAGE_NAME_OPTIMIZATION, this.getLayoutVersion()));
            assert (LayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, this.getLayoutVersion()));
            this.loadRoot(in, counter);
            this.loadDirectoryWithSnapshot(in, counter);
        }

        private void loadLocalNameINodes(long numFiles, DataInput in, StartupProgress.Counter counter) throws IOException {
            assert (LayoutVersion.supports(LayoutVersion.Feature.FSIMAGE_NAME_OPTIMIZATION, this.getLayoutVersion()));
            assert (numFiles > 0L);
            this.loadRoot(in, counter);
            --numFiles;
            while (numFiles > 0L) {
                numFiles -= (long)this.loadDirectory(in, counter);
            }
            if (numFiles != 0L) {
                throw new IOException("Read unexpect number of files: " + -numFiles);
            }
        }

        private void loadRoot(DataInput in, StartupProgress.Counter counter) throws IOException {
            if (in.readShort() != 0) {
                throw new IOException("First node is not root");
            }
            INodeDirectory root = this.loadINode(null, false, in, counter).asDirectory();
            this.updateRootAttr(root);
        }

        private int loadChildren(INodeDirectory parent, DataInput in, StartupProgress.Counter counter) throws IOException {
            int numChildren = in.readInt();
            for (int i = 0; i < numChildren; ++i) {
                INode newNode = this.loadINodeWithLocalName(false, in, true, counter);
                this.addToParent(parent, newNode);
            }
            return numChildren;
        }

        private void loadDirectoryWithSnapshot(DataInput in, StartupProgress.Counter counter) throws IOException {
            long inodeId = in.readLong();
            INodeDirectory parent = this.namesystem.dir.getInode(inodeId).asDirectory();
            boolean toLoadSubtree = this.referenceMap.toProcessSubtree(parent.getId());
            if (!toLoadSubtree) {
                return;
            }
            int numSnapshots = in.readInt();
            if (numSnapshots >= 0) {
                INodeDirectorySnapshottable snapshottableParent = INodeDirectorySnapshottable.valueOf((INode)parent, parent.getLocalName());
                SnapshotFSImageFormat.loadSnapshotList(snapshottableParent, numSnapshots, in, this);
                if (snapshottableParent.getSnapshotQuota() > 0) {
                    this.namesystem.getSnapshotManager().addSnapshottable(snapshottableParent);
                }
            }
            this.loadChildren(parent, in, counter);
            SnapshotFSImageFormat.loadDirectoryDiffList(parent, in, this);
            int numSubTree = in.readInt();
            for (int i = 0; i < numSubTree; ++i) {
                this.loadDirectoryWithSnapshot(in, counter);
            }
        }

        private int loadDirectory(DataInput in, StartupProgress.Counter counter) throws IOException {
            String parentPath = FSImageSerialization.readString(in);
            INodeDirectory parent = INodeDirectory.valueOf(this.namesystem.dir.rootDir.getNode(parentPath, true), parentPath);
            return this.loadChildren(parent, in, counter);
        }

        private void loadFullNameINodes(long numFiles, DataInput in, StartupProgress.Counter counter) throws IOException {
            Object parentPath = new byte[][]{new byte[0]};
            FSDirectory fsDir = this.namesystem.dir;
            INodeDirectory parentINode = fsDir.rootDir;
            for (long i = 0L; i < numFiles; ++i) {
                byte[][] pathComponents = FSImageSerialization.readPathComponents(in);
                INode newNode = this.loadINode(pathComponents[pathComponents.length - 1], false, in, counter);
                if (this.isRoot(pathComponents)) {
                    this.updateRootAttr(newNode.asDirectory());
                    continue;
                }
                if (!this.isParent(pathComponents, (byte[][])parentPath)) {
                    parentINode = this.getParentINodeDirectory(pathComponents);
                    parentPath = this.getParent(pathComponents);
                }
                this.addToParent(parentINode, newNode);
            }
        }

        private INodeDirectory getParentINodeDirectory(byte[][] pathComponents) throws FileNotFoundException, PathIsNotDirectoryException, UnresolvedLinkException {
            if (pathComponents.length < 2) {
                return null;
            }
            INodesInPath inodes = this.namesystem.dir.getExistingPathINodes(pathComponents);
            return INodeDirectory.valueOf(inodes.getINode(-2), pathComponents);
        }

        private void addToParent(INodeDirectory parent, INode child) {
            FSDirectory fsDir = this.namesystem.dir;
            if (parent == fsDir.rootDir && FSDirectory.isReservedName(child)) {
                throw new HadoopIllegalArgumentException("File name \"" + child.getLocalName() + "\" is reserved. Please " + " change the name of the existing file or directory to another " + "name before upgrading to this release.");
            }
            if (!parent.addChild(child)) {
                return;
            }
            this.namesystem.dir.cacheName(child);
            if (child.isFile()) {
                this.updateBlocksMap(child.asFile());
            }
        }

        public void updateBlocksMap(INodeFile file) {
            BlockInfo[] blocks = file.getBlocks();
            if (blocks != null) {
                BlockManager bm = this.namesystem.getBlockManager();
                for (int i = 0; i < blocks.length; ++i) {
                    file.setBlock(i, bm.addBlockCollection(blocks[i], file));
                }
            }
        }

        public FSDirectory getFSDirectoryInLoading() {
            return this.namesystem.dir;
        }

        public INode loadINodeWithLocalName(boolean isSnapshotINode, DataInput in, boolean updateINodeMap) throws IOException {
            return this.loadINodeWithLocalName(isSnapshotINode, in, updateINodeMap, null);
        }

        public INode loadINodeWithLocalName(boolean isSnapshotINode, DataInput in, boolean updateINodeMap, StartupProgress.Counter counter) throws IOException {
            byte[] localName = FSImageSerialization.readLocalName(in);
            INode inode = this.loadINode(localName, isSnapshotINode, in, counter);
            if (updateINodeMap && LayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, this.getLayoutVersion())) {
                this.namesystem.dir.addToInodeMap(inode);
            }
            return inode;
        }

        INode loadINode(byte[] localName, boolean isSnapshotINode, DataInput in, StartupProgress.Counter counter) throws IOException {
            int imgVersion = this.getLayoutVersion();
            if (LayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, imgVersion)) {
                this.namesystem.getFSDirectory().verifyINodeName(localName);
            }
            long inodeId = LayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, imgVersion) ? in.readLong() : this.namesystem.allocateNewInodeId();
            short replication = this.namesystem.getBlockManager().adjustReplication(in.readShort());
            long modificationTime = in.readLong();
            long atime = 0L;
            if (LayoutVersion.supports(LayoutVersion.Feature.FILE_ACCESS_TIME, imgVersion)) {
                atime = in.readLong();
            }
            long blockSize = in.readLong();
            int numBlocks = in.readInt();
            if (numBlocks >= 0) {
                BlockInfo[] blocks = null;
                if (numBlocks >= 0) {
                    blocks = new BlockInfo[numBlocks];
                    for (int j = 0; j < numBlocks; ++j) {
                        blocks[j] = new BlockInfo(replication);
                        blocks[j].readFields(in);
                    }
                }
                String clientName = "";
                String clientMachine = "";
                boolean underConstruction = false;
                FileWithSnapshot.FileDiffList fileDiffs = null;
                if (LayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, imgVersion)) {
                    fileDiffs = SnapshotFSImageFormat.loadFileDiffList(in, this);
                    if (isSnapshotINode && (underConstruction = in.readBoolean())) {
                        clientName = FSImageSerialization.readString(in);
                        clientMachine = FSImageSerialization.readString(in);
                        if (blocks != null && blocks.length > 0) {
                            BlockInfo lastBlk = blocks[blocks.length - 1];
                            blocks[blocks.length - 1] = new BlockInfoUnderConstruction(lastBlk, replication);
                        }
                    }
                }
                PermissionStatus permissions = PermissionStatus.read(in);
                if (counter != null) {
                    counter.increment();
                }
                INodeFile file = new INodeFile(inodeId, localName, permissions, modificationTime, atime, blocks, replication, blockSize);
                if (underConstruction) {
                    INodeFileUnderConstruction fileUC = new INodeFileUnderConstruction(file, clientName, clientMachine, null);
                    return fileDiffs == null ? fileUC : new INodeFileUnderConstructionWithSnapshot(fileUC, fileDiffs);
                }
                return fileDiffs == null ? file : new INodeFileWithSnapshot(file, fileDiffs);
            }
            if (numBlocks == -1) {
                INodeDirectory dir;
                long nsQuota = in.readLong();
                long dsQuota = -1L;
                if (LayoutVersion.supports(LayoutVersion.Feature.DISKSPACE_QUOTA, imgVersion)) {
                    dsQuota = in.readLong();
                }
                boolean snapshottable = false;
                boolean withSnapshot = false;
                if (LayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, imgVersion) && !(snapshottable = in.readBoolean())) {
                    withSnapshot = in.readBoolean();
                }
                PermissionStatus permissions = PermissionStatus.read(in);
                if (counter != null) {
                    counter.increment();
                }
                INodeDirectory iNodeDirectory = dir = nsQuota >= 0L || dsQuota >= 0L ? new INodeDirectoryWithQuota(inodeId, localName, permissions, modificationTime, nsQuota, dsQuota) : new INodeDirectory(inodeId, localName, permissions, modificationTime);
                return snapshottable ? new INodeDirectorySnapshottable(dir) : (withSnapshot ? new INodeDirectoryWithSnapshot(dir) : dir);
            }
            if (numBlocks == -2) {
                if (!FileSystem.areSymlinksEnabled()) {
                    throw new IOException("Symlinks not supported - please remove symlink before upgrading to this version of HDFS");
                }
                String symlink = Text.readString(in);
                PermissionStatus permissions = PermissionStatus.read(in);
                if (counter != null) {
                    counter.increment();
                }
                return new INodeSymlink(inodeId, localName, permissions, modificationTime, atime, symlink);
            }
            if (numBlocks == -3) {
                boolean isWithName = in.readBoolean();
                int snapshotId = in.readInt();
                INodeReference.WithCount withCount = this.referenceMap.loadINodeReferenceWithCount(isSnapshotINode, in, this);
                if (isWithName) {
                    return new INodeReference.WithName(null, withCount, localName, snapshotId);
                }
                INodeReference.DstReference ref = new INodeReference.DstReference(null, withCount, snapshotId);
                return ref;
            }
            throw new IOException("Unknown inode type: numBlocks=" + numBlocks);
        }

        public INodeFileAttributes loadINodeFileAttributes(DataInput in) throws IOException {
            int layoutVersion = this.getLayoutVersion();
            if (!LayoutVersion.supports(LayoutVersion.Feature.OPTIMIZE_SNAPSHOT_INODES, layoutVersion)) {
                return this.loadINodeWithLocalName(true, in, false).asFile();
            }
            byte[] name = FSImageSerialization.readLocalName(in);
            PermissionStatus permissions = PermissionStatus.read(in);
            long modificationTime = in.readLong();
            long accessTime = in.readLong();
            short replication = this.namesystem.getBlockManager().adjustReplication(in.readShort());
            long preferredBlockSize = in.readLong();
            return new INodeFileAttributes.SnapshotCopy(name, permissions, modificationTime, accessTime, replication, preferredBlockSize);
        }

        public INodeDirectoryAttributes loadINodeDirectoryAttributes(DataInput in) throws IOException {
            int layoutVersion = this.getLayoutVersion();
            if (!LayoutVersion.supports(LayoutVersion.Feature.OPTIMIZE_SNAPSHOT_INODES, layoutVersion)) {
                return this.loadINodeWithLocalName(true, in, false).asDirectory();
            }
            byte[] name = FSImageSerialization.readLocalName(in);
            PermissionStatus permissions = PermissionStatus.read(in);
            long modificationTime = in.readLong();
            long nsQuota = in.readLong();
            long dsQuota = in.readLong();
            return nsQuota == -1L && dsQuota == -1L ? new INodeDirectoryAttributes.SnapshotCopy(name, permissions, modificationTime) : new INodeDirectoryAttributes.CopyWithQuota(name, permissions, modificationTime, nsQuota, dsQuota);
        }

        private void loadFilesUnderConstruction(DataInput in, boolean supportSnapshot, StartupProgress.Counter counter) throws IOException {
            FSDirectory fsDir = this.namesystem.dir;
            int size = in.readInt();
            LOG.info((Object)("Number of files under construction = " + size));
            for (int i = 0; i < size; ++i) {
                INodeFileUnderConstruction cons = FSImageSerialization.readINodeUnderConstruction(in, this.namesystem, this.getLayoutVersion());
                counter.increment();
                String path = cons.getLocalName();
                INodeFile oldnode = null;
                boolean inSnapshot = false;
                if (path != null && FSDirectory.isReservedName(path) && LayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, this.getLayoutVersion())) {
                    oldnode = this.namesystem.dir.getInode(cons.getId()).asFile();
                    inSnapshot = true;
                } else {
                    INodesInPath iip = fsDir.getLastINodeInPath(path);
                    oldnode = INodeFile.valueOf(iip.getINode(0), path);
                }
                cons.setLocalName(oldnode.getLocalNameBytes());
                INodeReference parentRef = oldnode.getParentReference();
                if (parentRef != null) {
                    cons.setParentReference(parentRef);
                } else {
                    cons.setParent(oldnode.getParent());
                }
                if (oldnode instanceof INodeFileWithSnapshot) {
                    cons = new INodeFileUnderConstructionWithSnapshot(cons, ((INodeFileWithSnapshot)oldnode).getDiffs());
                }
                if (!inSnapshot) {
                    fsDir.replaceINodeFile(path, oldnode, cons);
                    this.namesystem.leaseManager.addLease(cons.getClientName(), path);
                    continue;
                }
                if (parentRef != null) {
                    parentRef.setReferredINode(cons);
                    continue;
                }
                oldnode.getParent().replaceChildFileInSnapshot(oldnode, cons);
                this.namesystem.dir.addToInodeMap(cons);
                this.updateBlocksMap(cons);
            }
        }

        private void loadSecretManagerState(DataInput in) throws IOException {
            int imgVersion = this.getLayoutVersion();
            if (!LayoutVersion.supports(LayoutVersion.Feature.DELEGATION_TOKEN, imgVersion)) {
                return;
            }
            this.namesystem.loadSecretManagerState(in);
        }

        private void loadCacheManagerState(DataInput in) throws IOException {
            int imgVersion = this.getLayoutVersion();
            if (!LayoutVersion.supports(LayoutVersion.Feature.CACHING, imgVersion)) {
                return;
            }
            this.namesystem.getCacheManager().loadState(in);
        }

        private int getLayoutVersion() {
            return this.namesystem.getFSImage().getStorage().getLayoutVersion();
        }

        private boolean isRoot(byte[][] path) {
            return path.length == 1 && path[0] == null;
        }

        private boolean isParent(byte[][] path, byte[][] parent) {
            if (path == null || parent == null) {
                return false;
            }
            if (parent.length == 0 || path.length != parent.length + 1) {
                return false;
            }
            boolean isParent = true;
            for (int i = 0; i < parent.length; ++i) {
                isParent = isParent && Arrays.equals(path[i], parent[i]);
            }
            return isParent;
        }

        String getParent(String path) {
            return path.substring(0, path.lastIndexOf("/"));
        }

        byte[][] getParent(byte[][] path) {
            byte[][] result = new byte[path.length - 1][];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new byte[path[i].length];
                System.arraycopy(path[i], 0, result[i], 0, path[i].length);
            }
            return result;
        }

        public Snapshot getSnapshot(DataInput in) throws IOException {
            return this.snapshotMap.get(in.readInt());
        }
    }
}

