/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.flink.hadoop2.shaded.com.google.common.base.CharMatcher;
import org.apache.flink.hadoop2.shaded.com.google.common.base.Preconditions;
import org.apache.flink.hadoop2.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.hadoop2.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
class Router {
    static final Logger LOG = LoggerFactory.getLogger(Router.class);
    static final ImmutableList<String> EMPTY_LIST = ImmutableList.of();
    static final CharMatcher SLASH = CharMatcher.is('/');
    static final Pattern controllerRe = Pattern.compile("^/[A-Za-z_]\\w*(?:/.*)?");
    Class<?> hostClass;
    final TreeMap<String, Dest> routes = Maps.newTreeMap();

    Router() {
    }

    synchronized Dest add(WebApp.HTTP httpMethod, String path, Class<? extends Controller> cls, String action, List<String> names) {
        LOG.debug("adding {}({})->{}#{}", new Object[]{path, names, cls, action});
        Dest dest = this.addController(httpMethod, path, cls, action, names);
        this.addDefaultView(dest);
        return dest;
    }

    private Dest addController(WebApp.HTTP httpMethod, String path, Class<? extends Controller> cls, String action, List<String> names) {
        try {
            Method method = cls.getMethod(action, null);
            Dest dest = this.routes.get(path);
            if (dest == null) {
                method.setAccessible(true);
                dest = new Dest(path, method, cls, names, httpMethod);
                this.routes.put(path, dest);
                return dest;
            }
            dest.methods.add(httpMethod);
            return dest;
        }
        catch (NoSuchMethodException nsme) {
            throw new WebAppException(action + "() not found in " + cls);
        }
        catch (SecurityException se) {
            throw new WebAppException("Security exception thrown for " + action + "() in " + cls);
        }
    }

    private void addDefaultView(Dest dest) {
        String controllerName = dest.controllerClass.getSimpleName();
        if (controllerName.endsWith("Controller")) {
            controllerName = controllerName.substring(0, controllerName.length() - 10);
        }
        dest.defaultViewClass = this.find(View.class, dest.controllerClass.getPackage().getName(), StringHelper.join(controllerName + "View"));
    }

    void setHostClass(Class<?> cls) {
        this.hostClass = cls;
    }

    synchronized Dest resolve(String httpMethod, String path) {
        WebApp.HTTP method = WebApp.HTTP.valueOf(httpMethod);
        Dest dest = this.lookupRoute(method, path);
        if (dest == null) {
            return this.resolveDefault(method, path);
        }
        return dest;
    }

    private Dest lookupRoute(WebApp.HTTP method, String path) {
        String key = path;
        while (true) {
            Dest dest;
            if ((dest = this.routes.get(key)) != null && Router.methodAllowed(method, dest)) {
                if (key == path) {
                    LOG.debug("exact match for {}: {}", (Object)key, (Object)dest.action);
                    return dest;
                }
                if (Router.isGoodMatch(dest, path)) {
                    LOG.debug("prefix match2 for {}: {}", (Object)key, (Object)dest.action);
                    return dest;
                }
                return this.resolveAction(method, dest, path);
            }
            Map.Entry<String, Dest> lower = this.routes.lowerEntry(key);
            if (lower == null) {
                return null;
            }
            dest = lower.getValue();
            if (Router.prefixMatches(dest, path)) {
                if (Router.methodAllowed(method, dest)) {
                    if (Router.isGoodMatch(dest, path)) {
                        LOG.debug("prefix match for {}: {}", (Object)lower.getKey(), (Object)dest.action);
                        return dest;
                    }
                    return this.resolveAction(method, dest, path);
                }
                int slashPos = key.lastIndexOf(47);
                key = slashPos > 0 ? path.substring(0, slashPos) : "/";
                continue;
            }
            key = "/";
        }
    }

    static boolean methodAllowed(WebApp.HTTP method, Dest dest) {
        return dest.methods.contains((Object)method) || dest.methods.size() == 1 && dest.methods.contains((Object)WebApp.HTTP.GET);
    }

    static boolean prefixMatches(Dest dest, String path) {
        LOG.debug("checking prefix {}{} for path: {}", new Object[]{dest.prefix, dest.pathParams, path});
        if (!path.startsWith(dest.prefix)) {
            return false;
        }
        int prefixLen = dest.prefix.length();
        return prefixLen <= 1 || path.length() <= prefixLen || path.charAt(prefixLen) == '/';
    }

    static boolean isGoodMatch(Dest dest, String path) {
        if (SLASH.countIn(dest.prefix) > 1) {
            return true;
        }
        if (dest.prefix.length() == 1) {
            return dest.pathParams.size() > 0 && !Router.maybeController(path);
        }
        return dest.pathParams.size() > 0 || path.endsWith("/") && SLASH.countIn(path) == 2;
    }

    static boolean maybeController(String path) {
        return controllerRe.matcher(path).matches();
    }

    private Dest resolveDefault(WebApp.HTTP method, String path) {
        List<String> parts = WebApp.parseRoute(path);
        String controller = parts.get(1);
        String action = parts.get(2);
        Class<Controller> cls = this.find(Controller.class, StringHelper.join(controller, "Controller"));
        if (cls == null) {
            cls = this.find(Controller.class, controller);
        }
        if (cls == null) {
            throw new WebAppException(StringHelper.join(path, ": controller for ", controller, " not found"));
        }
        return this.add(method, this.defaultPrefix(controller, action), cls, action, null);
    }

    private String defaultPrefix(String controller, String action) {
        if (controller.equals("default") && action.equals("index")) {
            return "/";
        }
        if (action.equals("index")) {
            return StringHelper.join(Character.valueOf('/'), controller);
        }
        return StringHelper.pjoin("", controller, action);
    }

    private <T> Class<? extends T> find(Class<T> cls, String cname) {
        String pkg = this.hostClass.getPackage().getName();
        return this.find(cls, pkg, cname);
    }

    private <T> Class<? extends T> find(Class<T> cls, String pkg, String cname) {
        String name = StringUtils.capitalize((String)cname);
        Class<T> found = this.load(cls, StringHelper.djoin(pkg, name));
        if (found == null) {
            found = this.load(cls, StringHelper.djoin(pkg, "webapp", name));
        }
        if (found == null) {
            found = this.load(cls, StringHelper.join(this.hostClass.getName(), Character.valueOf('$'), name));
        }
        return found;
    }

    private <T> Class<? extends T> load(Class<T> cls, String className) {
        LOG.debug("trying: {}", (Object)className);
        try {
            Class<?> found = Class.forName(className);
            if (cls.isAssignableFrom(found)) {
                LOG.debug("found {}", (Object)className);
                return found;
            }
            LOG.warn("found a {} but it's not a {}", (Object)className, (Object)cls.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private Dest resolveAction(WebApp.HTTP method, Dest dest, String path) {
        if (dest.prefix.length() == 1) {
            return null;
        }
        Preconditions.checkState(!Router.isGoodMatch(dest, path), dest.prefix);
        Preconditions.checkState(SLASH.countIn(path) > 1, path);
        List<String> parts = WebApp.parseRoute(path);
        String controller = parts.get(1);
        String action = parts.get(2);
        return this.add(method, StringHelper.pjoin("", controller, action), dest.controllerClass, action, null);
    }

    static class Dest {
        final String prefix;
        final ImmutableList<String> pathParams;
        final Method action;
        final Class<? extends Controller> controllerClass;
        Class<? extends View> defaultViewClass;
        final EnumSet<WebApp.HTTP> methods;

        Dest(String path, Method method, Class<? extends Controller> cls, List<String> pathParams, WebApp.HTTP httpMethod) {
            this.prefix = Preconditions.checkNotNull(path);
            this.action = Preconditions.checkNotNull(method);
            this.controllerClass = Preconditions.checkNotNull(cls);
            this.pathParams = pathParams != null ? ImmutableList.copyOf(pathParams) : EMPTY_LIST;
            this.methods = EnumSet.of(httpMethod);
        }
    }
}

