/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.apache.flink.hadoop2.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class DirectBufferPool {
    final ConcurrentMap<Integer, Queue<WeakReference<ByteBuffer>>> buffersBySize = new ConcurrentHashMap<Integer, Queue<WeakReference<ByteBuffer>>>();

    public ByteBuffer getBuffer(int size) {
        WeakReference ref;
        Queue list = (Queue)this.buffersBySize.get(size);
        if (list == null) {
            return ByteBuffer.allocateDirect(size);
        }
        while ((ref = (WeakReference)list.poll()) != null) {
            ByteBuffer b = (ByteBuffer)ref.get();
            if (b == null) continue;
            return b;
        }
        return ByteBuffer.allocateDirect(size);
    }

    public void returnBuffer(ByteBuffer buf) {
        buf.clear();
        int size = buf.capacity();
        Queue<WeakReference<ByteBuffer>> list = (ConcurrentLinkedQueue<WeakReference<ByteBuffer>>)this.buffersBySize.get(size);
        if (list == null) {
            list = new ConcurrentLinkedQueue<WeakReference<ByteBuffer>>();
            Queue prev = this.buffersBySize.putIfAbsent(size, list);
            if (prev != null) {
                list = prev;
            }
        }
        list.add(new WeakReference<ByteBuffer>(buf));
    }

    @VisibleForTesting
    int countBuffersOfSize(int size) {
        Queue list = (Queue)this.buffersBySize.get(size);
        if (list == null) {
            return 0;
        }
        return list.size();
    }
}

