/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.counters;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop2.shaded.com.google.common.collect.Iterables;
import org.apache.flink.hadoop2.shaded.com.google.common.collect.Iterators;
import org.apache.flink.hadoop2.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.FileSystemCounter;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.counters.CounterGroupBase;
import org.apache.hadoop.mapreduce.counters.CounterGroupFactory;
import org.apache.hadoop.mapreduce.counters.FileSystemCounterGroup;
import org.apache.hadoop.mapreduce.counters.FrameworkCounterGroup;
import org.apache.hadoop.mapreduce.counters.Limits;
import org.apache.hadoop.util.StringInterner;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class AbstractCounters<C extends Counter, G extends CounterGroupBase<C>>
implements Writable,
Iterable<G> {
    protected static final Log LOG = LogFactory.getLog((String)"mapreduce.Counters");
    private Map<Enum<?>, C> cache = Maps.newIdentityHashMap();
    private Map<String, G> fgroups = new ConcurrentSkipListMap<String, G>();
    private Map<String, G> groups = new ConcurrentSkipListMap<String, G>();
    private final CounterGroupFactory<C, G> groupFactory;
    private boolean writeAllCounters = true;
    private static final Map<String, String> legacyMap = Maps.newHashMap();
    private final Limits limits = new Limits();

    @InterfaceAudience.Private
    public AbstractCounters(CounterGroupFactory<C, G> gf) {
        this.groupFactory = gf;
    }

    @InterfaceAudience.Private
    public <C1 extends Counter, G1 extends CounterGroupBase<C1>> AbstractCounters(AbstractCounters<C1, G1> counters, CounterGroupFactory<C, G> groupFactory) {
        this.groupFactory = groupFactory;
        for (CounterGroupBase group : counters) {
            String name = group.getName();
            G newGroup = groupFactory.newGroup(name, group.getDisplayName(), this.limits);
            (CounterGroupFactory.isFrameworkGroup(name) ? this.fgroups : this.groups).put(name, newGroup);
            for (Counter counter : group) {
                newGroup.addCounter(counter.getName(), counter.getDisplayName(), counter.getValue());
            }
        }
    }

    @InterfaceAudience.Private
    public synchronized G addGroup(G group) {
        String name = group.getName();
        if (CounterGroupFactory.isFrameworkGroup(name)) {
            this.fgroups.put(name, group);
        } else {
            this.limits.checkGroups(this.groups.size() + 1);
            this.groups.put(name, group);
        }
        return group;
    }

    @InterfaceAudience.Private
    public G addGroup(String name, String displayName) {
        return this.addGroup(this.groupFactory.newGroup(name, displayName, this.limits));
    }

    public C findCounter(String groupName, String counterName) {
        G grp = this.getGroup(groupName);
        return (C)grp.findCounter(counterName);
    }

    public synchronized C findCounter(Enum<?> key) {
        Counter counter = (Counter)this.cache.get(key);
        if (counter == null) {
            counter = this.findCounter(key.getDeclaringClass().getName(), key.name());
            this.cache.put(key, counter);
        }
        return (C)counter;
    }

    @InterfaceAudience.Private
    public synchronized C findCounter(String scheme, FileSystemCounter key) {
        return ((FileSystemCounterGroup)this.getGroup(FileSystemCounter.class.getName()).getUnderlyingGroup()).findCounter(scheme, key);
    }

    public synchronized Iterable<String> getGroupNames() {
        HashSet<String> deprecated = new HashSet<String>();
        for (Map.Entry<String, String> entry : legacyMap.entrySet()) {
            String newGroup = entry.getValue();
            boolean isFGroup = CounterGroupFactory.isFrameworkGroup(newGroup);
            if (!(isFGroup ? this.fgroups.containsKey(newGroup) : this.groups.containsKey(newGroup))) continue;
            deprecated.add(entry.getKey());
        }
        return Iterables.concat(this.fgroups.keySet(), this.groups.keySet(), deprecated);
    }

    @Override
    public Iterator<G> iterator() {
        return Iterators.concat(this.fgroups.values().iterator(), this.groups.values().iterator());
    }

    public synchronized G getGroup(String groupName) {
        boolean isFGroup;
        CounterGroupBase<Object> group;
        boolean groupNameInLegacyMap = true;
        String newGroupName = legacyMap.get(groupName);
        if (newGroupName == null) {
            groupNameInLegacyMap = false;
            newGroupName = Limits.filterGroupName(groupName);
        }
        CounterGroupBase counterGroupBase = group = (isFGroup = CounterGroupFactory.isFrameworkGroup(newGroupName)) ? (CounterGroupBase)this.fgroups.get(newGroupName) : (CounterGroupBase)this.groups.get(newGroupName);
        if (group == null) {
            group = this.groupFactory.newGroup(newGroupName, this.limits);
            if (isFGroup) {
                this.fgroups.put(newGroupName, group);
            } else {
                this.limits.checkGroups(this.groups.size() + 1);
                this.groups.put(newGroupName, group);
            }
            if (groupNameInLegacyMap) {
                LOG.warn((Object)("Group " + groupName + " is deprecated. Use " + newGroupName + " instead"));
            }
        }
        return (G)group;
    }

    public synchronized int countCounters() {
        int result = 0;
        for (CounterGroupBase group : this) {
            result += group.size();
        }
        return result;
    }

    @Override
    public synchronized void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt(out, this.groupFactory.version());
        WritableUtils.writeVInt(out, this.fgroups.size());
        for (CounterGroupBase group : this.fgroups.values()) {
            if (group.getUnderlyingGroup() instanceof FrameworkCounterGroup) {
                WritableUtils.writeVInt(out, GroupType.FRAMEWORK.ordinal());
                WritableUtils.writeVInt(out, CounterGroupFactory.getFrameworkGroupId(group.getName()));
                group.write(out);
                continue;
            }
            if (!(group.getUnderlyingGroup() instanceof FileSystemCounterGroup)) continue;
            WritableUtils.writeVInt(out, GroupType.FILESYSTEM.ordinal());
            group.write(out);
        }
        if (this.writeAllCounters) {
            WritableUtils.writeVInt(out, this.groups.size());
            for (CounterGroupBase group : this.groups.values()) {
                Text.writeString(out, group.getName());
                group.write(out);
            }
        } else {
            WritableUtils.writeVInt(out, 0);
        }
    }

    @Override
    public synchronized void readFields(DataInput in) throws IOException {
        G group;
        int version = WritableUtils.readVInt(in);
        if (version != this.groupFactory.version()) {
            throw new IOException("Counters version mismatch, expected " + this.groupFactory.version() + " got " + version);
        }
        int numFGroups = WritableUtils.readVInt(in);
        this.fgroups.clear();
        GroupType[] groupTypes = GroupType.values();
        while (numFGroups-- > 0) {
            GroupType groupType = groupTypes[WritableUtils.readVInt(in)];
            switch (groupType) {
                case FILESYSTEM: {
                    group = this.groupFactory.newFileSystemGroup();
                    break;
                }
                case FRAMEWORK: {
                    group = this.groupFactory.newFrameworkGroup(WritableUtils.readVInt(in));
                    break;
                }
                default: {
                    throw new IOException("Unexpected counter group type: " + (Object)((Object)groupType));
                }
            }
            group.readFields(in);
            this.fgroups.put(group.getName(), group);
        }
        int numGroups = WritableUtils.readVInt(in);
        while (numGroups-- > 0) {
            this.limits.checkGroups(this.groups.size() + 1);
            group = this.groupFactory.newGenericGroup(StringInterner.weakIntern(Text.readString(in)), null, this.limits);
            group.readFields(in);
            this.groups.put(group.getName(), group);
        }
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("Counters: " + this.countCounters());
        for (CounterGroupBase group : this) {
            sb.append("\n\t").append(group.getDisplayName());
            for (Counter counter : group) {
                sb.append("\n\t\t").append(counter.getDisplayName()).append("=").append(counter.getValue());
            }
        }
        return sb.toString();
    }

    public synchronized void incrAllCounters(AbstractCounters<C, G> other) {
        for (CounterGroupBase right : other) {
            String groupName = right.getName();
            CounterGroupBase<Object> left = (CounterGroupBase)(CounterGroupFactory.isFrameworkGroup(groupName) ? this.fgroups : this.groups).get(groupName);
            if (left == null) {
                left = this.addGroup(groupName, right.getDisplayName());
            }
            left.incrAllCounters(right);
        }
    }

    public boolean equals(Object genericRight) {
        if (genericRight instanceof AbstractCounters) {
            return Iterators.elementsEqual(this.iterator(), ((AbstractCounters)genericRight).iterator());
        }
        return false;
    }

    public int hashCode() {
        return this.groups.hashCode();
    }

    @InterfaceAudience.Private
    public void setWriteAllCounters(boolean send) {
        this.writeAllCounters = send;
    }

    @InterfaceAudience.Private
    public boolean getWriteAllCounters() {
        return this.writeAllCounters;
    }

    @InterfaceAudience.Private
    public Limits limits() {
        return this.limits;
    }

    static {
        legacyMap.put("org.apache.hadoop.mapred.Task$Counter", TaskCounter.class.getName());
        legacyMap.put("org.apache.hadoop.mapred.JobInProgress$Counter", JobCounter.class.getName());
        legacyMap.put("FileSystemCounters", FileSystemCounter.class.getName());
    }

    static enum GroupType {
        FRAMEWORK,
        FILESYSTEM;

    }
}

