/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop2.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.shaded.hadoop2.io.netty.bootstrap.ServerBootstrap;
import org.apache.flink.shaded.hadoop2.io.netty.channel.Channel;
import org.apache.flink.shaded.hadoop2.io.netty.channel.ChannelInitializer;
import org.apache.flink.shaded.hadoop2.io.netty.channel.ChannelPipeline;
import org.apache.flink.shaded.hadoop2.io.netty.channel.EventLoopGroup;
import org.apache.flink.shaded.hadoop2.io.netty.channel.group.ChannelGroup;
import org.apache.flink.shaded.hadoop2.io.netty.channel.group.DefaultChannelGroup;
import org.apache.flink.shaded.hadoop2.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.flink.shaded.hadoop2.io.netty.channel.socket.SocketChannel;
import org.apache.flink.shaded.hadoop2.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.flink.shaded.hadoop2.io.netty.handler.codec.http.HttpRequestDecoder;
import org.apache.flink.shaded.hadoop2.io.netty.handler.codec.http.HttpResponseEncoder;
import org.apache.flink.shaded.hadoop2.io.netty.handler.codec.string.StringEncoder;
import org.apache.flink.shaded.hadoop2.io.netty.util.concurrent.GlobalEventExecutor;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FSImageHandler;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FSImageLoader;

public class WebImageViewer
implements Closeable {
    public static final Log LOG = LogFactory.getLog(WebImageViewer.class);
    private Channel channel;
    private InetSocketAddress address;
    private final ServerBootstrap bootstrap;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final ChannelGroup allChannels;

    public WebImageViewer(InetSocketAddress address) {
        this.address = address;
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.allChannels = new DefaultChannelGroup(GlobalEventExecutor.INSTANCE);
        this.bootstrap = (ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class);
    }

    public void start(String fsimage) throws IOException {
        try {
            this.initServer(fsimage);
            this.channel.closeFuture().await();
        }
        catch (InterruptedException e) {
            LOG.info((Object)"Interrupted. Stopping the WebImageViewer.");
            this.close();
        }
    }

    @VisibleForTesting
    public void initServer(String fsimage) throws IOException, InterruptedException {
        final FSImageLoader loader = FSImageLoader.load(fsimage);
        this.bootstrap.childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new HttpRequestDecoder(), new StringEncoder(), new HttpResponseEncoder(), new FSImageHandler(loader, WebImageViewer.this.allChannels));
            }
        });
        this.channel = this.bootstrap.bind(this.address).sync().channel();
        this.allChannels.add(this.channel);
        this.address = (InetSocketAddress)this.channel.localAddress();
        LOG.info((Object)("WebImageViewer started. Listening on " + this.address.toString() + ". Press Ctrl+C to stop the viewer."));
    }

    @VisibleForTesting
    public int getPort() {
        return this.address.getPort();
    }

    @Override
    public void close() {
        this.allChannels.close().awaitUninterruptibly();
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }
}

