/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.flink.hadoop2.shaded.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DebugAdmin
extends Configured
implements Tool {
    private DebugCommand[] DEBUG_COMMANDS = new DebugCommand[]{new VerifyBlockChecksumCommand(), new RecoverLeaseCommand(), new HelpCommand()};
    private static int HEADER_LEN = 7;

    public DebugAdmin(Configuration conf) {
        super(conf);
    }

    private DebugCommand popCommand(List<String> args) {
        String commandStr;
        String string = commandStr = args.size() == 0 ? "" : args.get(0);
        if (commandStr.startsWith("-")) {
            commandStr = commandStr.substring(1);
        }
        for (DebugCommand command : this.DEBUG_COMMANDS) {
            if (!command.name.equals(commandStr)) continue;
            args.remove(0);
            return command;
        }
        return null;
    }

    @Override
    public int run(String[] argv) {
        LinkedList<String> args = new LinkedList<String>();
        for (int j = 0; j < argv.length; ++j) {
            args.add(argv[j]);
        }
        DebugCommand command = this.popCommand(args);
        if (command == null) {
            this.printUsage();
            return 0;
        }
        try {
            return command.run(args);
        }
        catch (IOException e) {
            System.err.println("IOException: " + StringUtils.stringifyException(e));
            return 1;
        }
        catch (RuntimeException e) {
            System.err.println("RuntimeException: " + StringUtils.stringifyException(e));
            return 1;
        }
    }

    private void printUsage() {
        System.out.println("Usage: hdfs debug <command> [arguments]\n");
        for (DebugCommand command : this.DEBUG_COMMANDS) {
            if (command.name.equals("help")) continue;
            System.out.println(command.usageText);
        }
    }

    public static void main(String[] argsArray) throws IOException {
        DebugAdmin debugAdmin = new DebugAdmin(new Configuration());
        System.exit(debugAdmin.run(argsArray));
    }

    static /* synthetic */ int access$000() {
        return HEADER_LEN;
    }

    private class HelpCommand
    extends DebugCommand {
        HelpCommand() {
            super("help", "help [command-name]", "  Get help about a command.");
        }

        @Override
        int run(List<String> args) {
            DebugCommand command = DebugAdmin.this.popCommand(args);
            if (command == null) {
                DebugAdmin.this.printUsage();
                return 0;
            }
            System.out.println(command.usageText);
            System.out.println(command.helpText + "\n");
            return 0;
        }
    }

    private class RecoverLeaseCommand
    extends DebugCommand {
        private static final int TIMEOUT_MS = 5000;

        RecoverLeaseCommand() {
            super("recoverLease", "recoverLease -path <path> [-retries <num-retries>]", "  Recover the lease on the specified path.  The path must reside on an\n  HDFS filesystem.  The default number of retries is 1.");
        }

        @Override
        int run(List<String> args) throws IOException {
            FileSystem fs;
            if (args.size() == 0) {
                System.out.println(this.usageText);
                System.out.println(this.helpText + "\n");
                return 1;
            }
            String pathStr = StringUtils.popOptionWithArgument("-path", args);
            String retriesStr = StringUtils.popOptionWithArgument("-retries", args);
            if (pathStr == null) {
                System.err.println("You must supply a -path argument to recoverLease.");
                return 1;
            }
            int maxRetries = 1;
            if (retriesStr != null) {
                try {
                    maxRetries = Integer.parseInt(retriesStr);
                }
                catch (NumberFormatException e) {
                    System.err.println("Failed to parse the argument to -retries: " + StringUtils.stringifyException(e));
                    return 1;
                }
            }
            try {
                fs = FileSystem.newInstance(new URI(pathStr), DebugAdmin.this.getConf(), null);
            }
            catch (URISyntaxException e) {
                System.err.println("URISyntaxException for " + pathStr + ":" + StringUtils.stringifyException(e));
                return 1;
            }
            catch (InterruptedException e) {
                System.err.println("InterruptedException for " + pathStr + ":" + StringUtils.stringifyException(e));
                return 1;
            }
            DistributedFileSystem dfs = null;
            try {
                dfs = (DistributedFileSystem)fs;
            }
            catch (ClassCastException e) {
                System.err.println("Invalid filesystem for path " + pathStr + ": " + "needed scheme hdfs, but got: " + fs.getScheme());
                return 1;
            }
            int retry = 0;
            while (true) {
                boolean recovered = false;
                IOException ioe = null;
                try {
                    recovered = dfs.recoverLease(new Path(pathStr));
                }
                catch (IOException e) {
                    ioe = e;
                }
                if (recovered) {
                    System.out.println("recoverLease SUCCEEDED on " + pathStr);
                    return 0;
                }
                if (ioe != null) {
                    System.err.println("recoverLease got exception: ");
                    ioe.printStackTrace();
                } else {
                    System.err.println("recoverLease returned false.");
                }
                if (++retry >= maxRetries) break;
                System.err.println("Retrying in 5000 ms...");
                Uninterruptibles.sleepUninterruptibly(5000L, TimeUnit.MILLISECONDS);
                System.err.println("Retry #" + retry);
            }
            System.err.println("Giving up on recoverLease for " + pathStr + " after " + maxRetries + (maxRetries == 1 ? " try." : " tries."));
            return 1;
        }
    }

    private class VerifyBlockChecksumCommand
    extends DebugCommand {
        VerifyBlockChecksumCommand() {
            super("verify", "verify -meta <metadata-file> [-block <block-file>]", "  Verify HDFS metadata and block files.  If a block file is specified, we\n  will verify that the checksums in the metadata file match the block\n  file.");
        }

        /*
         * Exception decompiling
         */
        @Override
        int run(List<String> args) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private abstract class DebugCommand {
        final String name;
        final String usageText;
        final String helpText;

        DebugCommand(String name, String usageText, String helpText) {
            this.name = name;
            this.usageText = usageText;
            this.helpText = helpText;
        }

        abstract int run(List<String> var1) throws IOException;
    }
}

