/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.hadoop2.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.DirectoryListingStartAfterNotFoundException;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.FsPermissionExtension;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.server.namenode.CacheManager;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectorySnapshottableFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.util.ReadOnlyList;

class FSDirStatAndListingOp {
    FSDirStatAndListingOp() {
    }

    static DirectoryListing getListingInt(FSDirectory fsd, String srcArg, byte[] startAfter, boolean needLocation) throws IOException {
        FSPermissionChecker pc = fsd.getPermissionChecker();
        String startAfterString = DFSUtil.bytes2String(startAfter);
        INodesInPath iip = fsd.resolvePath(pc, srcArg);
        String src = iip.getPath();
        if (FSDirectory.isReservedName(startAfterString)) {
            try {
                String tmp = FSDirectory.resolvePath(startAfterString, fsd);
                byte[][] regularPath = INode.getPathComponents(tmp);
                startAfter = regularPath[regularPath.length - 1];
            }
            catch (IOException e) {
                throw new DirectoryListingStartAfterNotFoundException("Can't find startAfter " + startAfterString);
            }
        }
        boolean isSuperUser = true;
        if (fsd.isPermissionEnabled()) {
            if (iip.getLastINode() != null && iip.getLastINode().isDirectory()) {
                fsd.checkPathAccess(pc, iip, FsAction.READ_EXECUTE);
            } else {
                fsd.checkTraverse(pc, iip);
            }
            isSuperUser = pc.isSuperUser();
        }
        return FSDirStatAndListingOp.getListing(fsd, iip, src, startAfter, needLocation, isSuperUser);
    }

    static HdfsFileStatus getFileInfo(FSDirectory fsd, String srcArg, boolean resolveLink) throws IOException {
        String src = srcArg;
        if (!DFSUtil.isValidName(src)) {
            throw new InvalidPathException("Invalid file name: " + src);
        }
        if (fsd.isPermissionEnabled()) {
            FSPermissionChecker pc = fsd.getPermissionChecker();
            INodesInPath iip = fsd.resolvePath(pc, srcArg, resolveLink);
            src = iip.getPath();
            fsd.checkPermission(pc, iip, false, null, null, null, null, false);
        } else {
            src = FSDirectory.resolvePath(srcArg, fsd);
        }
        return FSDirStatAndListingOp.getFileInfo(fsd, src, FSDirectory.isReservedRawName(srcArg), resolveLink);
    }

    static boolean isFileClosed(FSDirectory fsd, String src) throws IOException {
        FSPermissionChecker pc = fsd.getPermissionChecker();
        INodesInPath iip = fsd.resolvePath(pc, src);
        src = iip.getPath();
        if (fsd.isPermissionEnabled()) {
            fsd.checkTraverse(pc, iip);
        }
        return !INodeFile.valueOf(iip.getLastINode(), src).isUnderConstruction();
    }

    static ContentSummary getContentSummary(FSDirectory fsd, String src) throws IOException {
        FSPermissionChecker pc = fsd.getPermissionChecker();
        INodesInPath iip = fsd.resolvePath(pc, src);
        if (fsd.isPermissionEnabled()) {
            fsd.checkPermission(pc, iip, false, null, null, null, FsAction.READ_EXECUTE);
        }
        return FSDirStatAndListingOp.getContentSummaryInt(fsd, iip);
    }

    private static byte getStoragePolicyID(byte inodePolicy, byte parentPolicy) {
        return inodePolicy != 0 ? inodePolicy : parentPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DirectoryListing getListing(FSDirectory fsd, INodesInPath iip, String src, byte[] startAfter, boolean needLocation, boolean isSuperUser) throws IOException {
        String srcs = FSDirectory.normalizePath(src);
        boolean isRawPath = FSDirectory.isReservedRawName(src);
        fsd.readLock();
        try {
            byte parentStoragePolicy;
            if (srcs.endsWith("/.snapshot")) {
                DirectoryListing directoryListing = FSDirStatAndListingOp.getSnapshotsListing(fsd, srcs, startAfter);
                return directoryListing;
            }
            int snapshot = iip.getPathSnapshotId();
            INode targetNode = iip.getLastINode();
            if (targetNode == null) {
                DirectoryListing directoryListing = null;
                return directoryListing;
            }
            byte by = parentStoragePolicy = isSuperUser ? targetNode.getStoragePolicyID() : (byte)0;
            if (!targetNode.isDirectory()) {
                INodeAttributes nodeAttrs = FSDirStatAndListingOp.getINodeAttributes(fsd, src, HdfsFileStatus.EMPTY_NAME, targetNode, snapshot);
                DirectoryListing directoryListing = new DirectoryListing(new HdfsFileStatus[]{FSDirStatAndListingOp.createFileStatus(fsd, HdfsFileStatus.EMPTY_NAME, nodeAttrs, needLocation, parentStoragePolicy, snapshot, isRawPath, iip)}, 0);
                return directoryListing;
            }
            INodeDirectory dirInode = targetNode.asDirectory();
            ReadOnlyList<INode> contents = dirInode.getChildrenList(snapshot);
            int startChild = INodeDirectory.nextChild(contents, startAfter);
            int totalNumChildren = contents.size();
            int numOfListing = Math.min(totalNumChildren - startChild, fsd.getLsLimit());
            int locationBudget = fsd.getLsLimit();
            int listingCnt = 0;
            HdfsFileStatus[] listing = new HdfsFileStatus[numOfListing];
            for (int i = 0; i < numOfListing && locationBudget > 0; ++i) {
                INode cur = contents.get(startChild + i);
                byte curPolicy = isSuperUser && !cur.isSymlink() ? cur.getLocalStoragePolicyID() : (byte)0;
                INodeAttributes nodeAttrs = FSDirStatAndListingOp.getINodeAttributes(fsd, src, cur.getLocalNameBytes(), cur, snapshot);
                INodesInPath iipWithChild = INodesInPath.append(iip, cur, cur.getLocalNameBytes());
                listing[i] = FSDirStatAndListingOp.createFileStatus(fsd, cur.getLocalNameBytes(), nodeAttrs, needLocation, FSDirStatAndListingOp.getStoragePolicyID(curPolicy, parentStoragePolicy), snapshot, isRawPath, iipWithChild);
                ++listingCnt;
                if (!needLocation) continue;
                LocatedBlocks blks = ((HdfsLocatedFileStatus)listing[i]).getBlockLocations();
                locationBudget -= blks == null ? 0 : blks.locatedBlockCount() * listing[i].getReplication();
            }
            if (listingCnt < numOfListing) {
                listing = Arrays.copyOf(listing, listingCnt);
            }
            DirectoryListing directoryListing = new DirectoryListing(listing, totalNumChildren - startChild - listingCnt);
            return directoryListing;
        }
        finally {
            fsd.readUnlock();
        }
    }

    private static DirectoryListing getSnapshotsListing(FSDirectory fsd, String src, byte[] startAfter) throws IOException {
        Preconditions.checkState(fsd.hasReadLock());
        Preconditions.checkArgument(src.endsWith("/.snapshot"), "%s does not end with %s", src, "/.snapshot");
        String dirPath = FSDirectory.normalizePath(src.substring(0, src.length() - ".snapshot".length()));
        INode node = fsd.getINode(dirPath);
        INodeDirectory dirNode = INodeDirectory.valueOf(node, dirPath);
        DirectorySnapshottableFeature sf = dirNode.getDirectorySnapshottableFeature();
        if (sf == null) {
            throw new SnapshotException("Directory is not a snapshottable directory: " + dirPath);
        }
        ReadOnlyList<Snapshot> snapshots = sf.getSnapshotList();
        int skipSize = ReadOnlyList.Util.binarySearch(snapshots, startAfter);
        skipSize = skipSize < 0 ? -skipSize - 1 : skipSize + 1;
        int numOfListing = Math.min(snapshots.size() - skipSize, fsd.getLsLimit());
        HdfsFileStatus[] listing = new HdfsFileStatus[numOfListing];
        for (int i = 0; i < numOfListing; ++i) {
            Snapshot.Root sRoot = snapshots.get(i + skipSize).getRoot();
            INodeAttributes nodeAttrs = FSDirStatAndListingOp.getINodeAttributes(fsd, src, sRoot.getLocalNameBytes(), node, 0x7FFFFFFE);
            listing[i] = FSDirStatAndListingOp.createFileStatus(fsd, sRoot.getLocalNameBytes(), nodeAttrs, (byte)0, 0x7FFFFFFE, false, INodesInPath.fromINode(sRoot));
        }
        return new DirectoryListing(listing, snapshots.size() - skipSize - numOfListing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsFileStatus getFileInfo(FSDirectory fsd, String path, INodesInPath src, boolean isRawPath, boolean includeStoragePolicy) throws IOException {
        fsd.readLock();
        try {
            INode i = src.getLastINode();
            if (i == null) {
                HdfsFileStatus hdfsFileStatus = null;
                return hdfsFileStatus;
            }
            byte policyId = includeStoragePolicy && !i.isSymlink() ? i.getStoragePolicyID() : (byte)0;
            INodeAttributes nodeAttrs = FSDirStatAndListingOp.getINodeAttributes(fsd, path, HdfsFileStatus.EMPTY_NAME, i, src.getPathSnapshotId());
            HdfsFileStatus hdfsFileStatus = FSDirStatAndListingOp.createFileStatus(fsd, HdfsFileStatus.EMPTY_NAME, nodeAttrs, policyId, src.getPathSnapshotId(), isRawPath, src);
            return hdfsFileStatus;
        }
        finally {
            fsd.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsFileStatus getFileInfo(FSDirectory fsd, String src, boolean resolveLink, boolean isRawPath) throws IOException {
        fsd.readLock();
        try {
            HdfsFileStatus status = null;
            INodesInPath iip = fsd.getINodesInPath(src, resolveLink);
            if (FSDirectory.isExactReservedName(iip.getPathComponents())) {
                status = new HdfsFileStatus(0L, true, 0, 0L, 0L, 0L, new FsPermission(1016), null, null, null, HdfsFileStatus.EMPTY_NAME, -1L, 0, null, 0);
            } else if (iip.isDotSnapshotDir()) {
                if (fsd.getINode4DotSnapshot(iip) != null) {
                    status = FSDirectory.DOT_SNAPSHOT_DIR_STATUS;
                }
            } else {
                status = FSDirStatAndListingOp.getFileInfo(fsd, src, iip, isRawPath, true);
            }
            HdfsFileStatus hdfsFileStatus = status;
            return hdfsFileStatus;
        }
        finally {
            fsd.readUnlock();
        }
    }

    private static HdfsFileStatus createFileStatus(FSDirectory fsd, byte[] path, INodeAttributes nodeAttrs, boolean needLocation, byte storagePolicy, int snapshot, boolean isRawPath, INodesInPath iip) throws IOException {
        if (needLocation) {
            return FSDirStatAndListingOp.createLocatedFileStatus(fsd, path, nodeAttrs, storagePolicy, snapshot, isRawPath, iip);
        }
        return FSDirStatAndListingOp.createFileStatus(fsd, path, nodeAttrs, storagePolicy, snapshot, isRawPath, iip);
    }

    static HdfsFileStatus createFileStatusForEditLog(FSDirectory fsd, String fullPath, byte[] path, byte storagePolicy, int snapshot, boolean isRawPath, INodesInPath iip) throws IOException {
        INodeAttributes nodeAttrs = FSDirStatAndListingOp.getINodeAttributes(fsd, fullPath, path, iip.getLastINode(), snapshot);
        return FSDirStatAndListingOp.createFileStatus(fsd, path, nodeAttrs, storagePolicy, snapshot, isRawPath, iip);
    }

    static HdfsFileStatus createFileStatus(FSDirectory fsd, byte[] path, INodeAttributes nodeAttrs, byte storagePolicy, int snapshot, boolean isRawPath, INodesInPath iip) throws IOException {
        boolean isEncrypted;
        FileEncryptionInfo feInfo;
        long size = 0L;
        short replication = 0;
        long blocksize = 0L;
        INode node = iip.getLastINode();
        FileEncryptionInfo fileEncryptionInfo = feInfo = isRawPath ? null : fsd.getFileEncryptionInfo(node, snapshot, iip);
        if (node.isFile()) {
            INodeFile fileNode = node.asFile();
            size = fileNode.computeFileSize(snapshot);
            replication = fileNode.getFileReplication(snapshot);
            blocksize = fileNode.getPreferredBlockSize();
            isEncrypted = feInfo != null || isRawPath && fsd.isInAnEZ(iip);
        } else {
            isEncrypted = fsd.isInAnEZ(iip);
        }
        int childrenNum = node.isDirectory() ? node.asDirectory().getChildrenNum(snapshot) : 0;
        return new HdfsFileStatus(size, node.isDirectory(), replication, blocksize, node.getModificationTime(snapshot), node.getAccessTime(snapshot), FSDirStatAndListingOp.getPermissionForFileStatus(nodeAttrs, isEncrypted), nodeAttrs.getUserName(), nodeAttrs.getGroupName(), node.isSymlink() ? node.asSymlink().getSymlink() : null, path, node.getId(), childrenNum, feInfo, storagePolicy);
    }

    private static INodeAttributes getINodeAttributes(FSDirectory fsd, String fullPath, byte[] path, INode node, int snapshot) {
        return fsd.getAttributes(fullPath, path, node, snapshot);
    }

    private static HdfsLocatedFileStatus createLocatedFileStatus(FSDirectory fsd, byte[] path, INodeAttributes nodeAttrs, byte storagePolicy, int snapshot, boolean isRawPath, INodesInPath iip) throws IOException {
        boolean isEncrypted;
        FileEncryptionInfo feInfo;
        assert (fsd.hasReadLock());
        long size = 0L;
        short replication = 0;
        long blocksize = 0L;
        LocatedBlocks loc = null;
        INode node = iip.getLastINode();
        FileEncryptionInfo fileEncryptionInfo = feInfo = isRawPath ? null : fsd.getFileEncryptionInfo(node, snapshot, iip);
        if (node.isFile()) {
            INodeFile fileNode = node.asFile();
            size = fileNode.computeFileSize(snapshot);
            replication = fileNode.getFileReplication(snapshot);
            blocksize = fileNode.getPreferredBlockSize();
            boolean inSnapshot = snapshot != 0x7FFFFFFE;
            boolean isUc = !inSnapshot && fileNode.isUnderConstruction();
            long fileSize = !inSnapshot && isUc ? fileNode.computeFileSizeNotIncludingLastUcBlock() : size;
            loc = fsd.getFSNamesystem().getBlockManager().createLocatedBlocks(fileNode.getBlocks(snapshot), fileSize, isUc, 0L, size, false, inSnapshot, feInfo);
            if (loc == null) {
                loc = new LocatedBlocks();
            }
            isEncrypted = feInfo != null || isRawPath && fsd.isInAnEZ(iip);
        } else {
            isEncrypted = fsd.isInAnEZ(iip);
        }
        int childrenNum = node.isDirectory() ? node.asDirectory().getChildrenNum(snapshot) : 0;
        HdfsLocatedFileStatus status = new HdfsLocatedFileStatus(size, node.isDirectory(), replication, blocksize, node.getModificationTime(snapshot), node.getAccessTime(snapshot), FSDirStatAndListingOp.getPermissionForFileStatus(nodeAttrs, isEncrypted), nodeAttrs.getUserName(), nodeAttrs.getGroupName(), node.isSymlink() ? node.asSymlink().getSymlink() : null, path, node.getId(), loc, childrenNum, feInfo, storagePolicy);
        if (loc != null) {
            CacheManager cacheManager = fsd.getFSNamesystem().getCacheManager();
            for (LocatedBlock lb : loc.getLocatedBlocks()) {
                cacheManager.setCachedLocations(lb);
            }
        }
        return status;
    }

    private static FsPermission getPermissionForFileStatus(INodeAttributes node, boolean isEncrypted) {
        boolean hasAcl;
        FsPermission perm = node.getFsPermission();
        boolean bl = hasAcl = node.getAclFeature() != null;
        if (hasAcl || isEncrypted) {
            perm = new FsPermissionExtension(perm, hasAcl, isEncrypted);
        }
        return perm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ContentSummary getContentSummaryInt(FSDirectory fsd, INodesInPath iip) throws IOException {
        fsd.readLock();
        try {
            INode targetNode = iip.getLastINode();
            if (targetNode == null) {
                throw new FileNotFoundException("File does not exist: " + iip.getPath());
            }
            ContentSummaryComputationContext cscc = new ContentSummaryComputationContext(fsd, fsd.getFSNamesystem(), fsd.getContentCountLimit(), fsd.getContentSleepMicroSec());
            ContentSummary cs = targetNode.computeAndConvertContentSummary(cscc);
            fsd.addYieldCount(cscc.getYieldCount());
            ContentSummary contentSummary = cs;
            return contentSummary;
        }
        finally {
            fsd.readUnlock();
        }
    }
}

