/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.metrics;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.metrics2.source.JvmMetrics;

@InterfaceAudience.Private
@Metrics(about="DataNode metrics", context="dfs")
public class DataNodeMetrics {
    @Metric
    MutableCounterLong bytesWritten;
    @Metric(value={"Milliseconds spent writing"})
    MutableCounterLong totalWriteTime;
    @Metric
    MutableCounterLong bytesRead;
    @Metric(value={"Milliseconds spent reading"})
    MutableCounterLong totalReadTime;
    @Metric
    MutableCounterLong blocksWritten;
    @Metric
    MutableCounterLong blocksRead;
    @Metric
    MutableCounterLong blocksReplicated;
    @Metric
    MutableCounterLong blocksRemoved;
    @Metric
    MutableCounterLong blocksVerified;
    @Metric
    MutableCounterLong blockVerificationFailures;
    @Metric
    MutableCounterLong blocksCached;
    @Metric
    MutableCounterLong blocksUncached;
    @Metric
    MutableCounterLong readsFromLocalClient;
    @Metric
    MutableCounterLong readsFromRemoteClient;
    @Metric
    MutableCounterLong writesFromLocalClient;
    @Metric
    MutableCounterLong writesFromRemoteClient;
    @Metric
    MutableCounterLong blocksGetLocalPathInfo;
    @Metric(value={"Bytes read by remote client"})
    MutableCounterLong remoteBytesRead;
    @Metric(value={"Bytes written by remote client"})
    MutableCounterLong remoteBytesWritten;
    @Metric
    MutableCounterLong ramDiskBlocksWrite;
    @Metric
    MutableCounterLong ramDiskBlocksWriteFallback;
    @Metric
    MutableCounterLong ramDiskBytesWrite;
    @Metric
    MutableCounterLong ramDiskBlocksReadHits;
    @Metric
    MutableCounterLong ramDiskBlocksEvicted;
    @Metric
    MutableCounterLong ramDiskBlocksEvictedWithoutRead;
    @Metric
    MutableRate ramDiskBlocksEvictionWindowMs;
    final MutableQuantiles[] ramDiskBlocksEvictionWindowMsQuantiles;
    @Metric
    MutableCounterLong ramDiskBlocksLazyPersisted;
    @Metric
    MutableCounterLong ramDiskBlocksDeletedBeforeLazyPersisted;
    @Metric
    MutableCounterLong ramDiskBytesLazyPersisted;
    @Metric
    MutableRate ramDiskBlocksLazyPersistWindowMs;
    final MutableQuantiles[] ramDiskBlocksLazyPersistWindowMsQuantiles;
    @Metric
    MutableCounterLong fsyncCount;
    @Metric
    MutableCounterLong volumeFailures;
    @Metric(value={"Count of network errors on the datanode"})
    MutableCounterLong datanodeNetworkErrors;
    @Metric
    MutableRate readBlockOp;
    @Metric
    MutableRate writeBlockOp;
    @Metric
    MutableRate blockChecksumOp;
    @Metric
    MutableRate copyBlockOp;
    @Metric
    MutableRate replaceBlockOp;
    @Metric
    MutableRate heartbeats;
    @Metric
    MutableRate blockReports;
    @Metric
    MutableRate incrementalBlockReports;
    @Metric
    MutableRate cacheReports;
    @Metric
    MutableRate packetAckRoundTripTimeNanos;
    final MutableQuantiles[] packetAckRoundTripTimeNanosQuantiles;
    @Metric
    MutableRate flushNanos;
    final MutableQuantiles[] flushNanosQuantiles;
    @Metric
    MutableRate fsyncNanos;
    final MutableQuantiles[] fsyncNanosQuantiles;
    @Metric
    MutableRate sendDataPacketBlockedOnNetworkNanos;
    final MutableQuantiles[] sendDataPacketBlockedOnNetworkNanosQuantiles;
    @Metric
    MutableRate sendDataPacketTransferNanos;
    final MutableQuantiles[] sendDataPacketTransferNanosQuantiles;
    final MetricsRegistry registry = new MetricsRegistry("datanode");
    final String name;
    JvmMetrics jvmMetrics = null;

    public DataNodeMetrics(String name, String sessionId, int[] intervals, JvmMetrics jvmMetrics) {
        this.name = name;
        this.jvmMetrics = jvmMetrics;
        this.registry.tag(MsInfo.SessionId, sessionId);
        int len = intervals.length;
        this.packetAckRoundTripTimeNanosQuantiles = new MutableQuantiles[len];
        this.flushNanosQuantiles = new MutableQuantiles[len];
        this.fsyncNanosQuantiles = new MutableQuantiles[len];
        this.sendDataPacketBlockedOnNetworkNanosQuantiles = new MutableQuantiles[len];
        this.sendDataPacketTransferNanosQuantiles = new MutableQuantiles[len];
        this.ramDiskBlocksEvictionWindowMsQuantiles = new MutableQuantiles[len];
        this.ramDiskBlocksLazyPersistWindowMsQuantiles = new MutableQuantiles[len];
        for (int i = 0; i < len; ++i) {
            int interval = intervals[i];
            this.packetAckRoundTripTimeNanosQuantiles[i] = this.registry.newQuantiles("packetAckRoundTripTimeNanos" + interval + "s", "Packet Ack RTT in ns", "ops", "latency", interval);
            this.flushNanosQuantiles[i] = this.registry.newQuantiles("flushNanos" + interval + "s", "Disk flush latency in ns", "ops", "latency", interval);
            this.fsyncNanosQuantiles[i] = this.registry.newQuantiles("fsyncNanos" + interval + "s", "Disk fsync latency in ns", "ops", "latency", interval);
            this.sendDataPacketBlockedOnNetworkNanosQuantiles[i] = this.registry.newQuantiles("sendDataPacketBlockedOnNetworkNanos" + interval + "s", "Time blocked on network while sending a packet in ns", "ops", "latency", interval);
            this.sendDataPacketTransferNanosQuantiles[i] = this.registry.newQuantiles("sendDataPacketTransferNanos" + interval + "s", "Time reading from disk and writing to network while sending a packet in ns", "ops", "latency", interval);
            this.ramDiskBlocksEvictionWindowMsQuantiles[i] = this.registry.newQuantiles("ramDiskBlocksEvictionWindows" + interval + "s", "Time between the RamDisk block write and eviction in ms", "ops", "latency", interval);
            this.ramDiskBlocksLazyPersistWindowMsQuantiles[i] = this.registry.newQuantiles("ramDiskBlocksLazyPersistWindows" + interval + "s", "Time between the RamDisk block write and disk persist in ms", "ops", "latency", interval);
        }
    }

    public static DataNodeMetrics create(Configuration conf, String dnName) {
        String sessionId = conf.get("dfs.metrics.session-id");
        MetricsSystem ms = DefaultMetricsSystem.instance();
        JvmMetrics jm = JvmMetrics.create("DataNode", sessionId, ms);
        String name = "DataNodeActivity-" + (dnName.isEmpty() ? "UndefinedDataNodeName" + DFSUtil.getRandom().nextInt() : dnName.replace(':', '-'));
        int[] intervals = conf.getInts("dfs.metrics.percentiles.intervals");
        return ms.register(name, null, new DataNodeMetrics(name, sessionId, intervals, jm));
    }

    public String name() {
        return this.name;
    }

    public JvmMetrics getJvmMetrics() {
        return this.jvmMetrics;
    }

    public void addHeartbeat(long latency) {
        this.heartbeats.add(latency);
    }

    public void addBlockReport(long latency) {
        this.blockReports.add(latency);
    }

    public void addIncrementalBlockReport(long latency) {
        this.incrementalBlockReports.add(latency);
    }

    public void addCacheReport(long latency) {
        this.cacheReports.add(latency);
    }

    public void incrBlocksReplicated(int delta) {
        this.blocksReplicated.incr(delta);
    }

    public void incrBlocksWritten() {
        this.blocksWritten.incr();
    }

    public void incrBlocksRemoved(int delta) {
        this.blocksRemoved.incr(delta);
    }

    public void incrBytesWritten(int delta) {
        this.bytesWritten.incr(delta);
    }

    public void incrBlockVerificationFailures() {
        this.blockVerificationFailures.incr();
    }

    public void incrBlocksVerified() {
        this.blocksVerified.incr();
    }

    public void incrBlocksCached(int delta) {
        this.blocksCached.incr(delta);
    }

    public void incrBlocksUncached(int delta) {
        this.blocksUncached.incr(delta);
    }

    public void addReadBlockOp(long latency) {
        this.readBlockOp.add(latency);
    }

    public void addWriteBlockOp(long latency) {
        this.writeBlockOp.add(latency);
    }

    public void addReplaceBlockOp(long latency) {
        this.replaceBlockOp.add(latency);
    }

    public void addCopyBlockOp(long latency) {
        this.copyBlockOp.add(latency);
    }

    public void addBlockChecksumOp(long latency) {
        this.blockChecksumOp.add(latency);
    }

    public void incrBytesRead(int delta) {
        this.bytesRead.incr(delta);
    }

    public void incrBlocksRead() {
        this.blocksRead.incr();
    }

    public void incrFsyncCount() {
        this.fsyncCount.incr();
    }

    public void incrTotalWriteTime(long timeTaken) {
        this.totalWriteTime.incr(timeTaken);
    }

    public void incrTotalReadTime(long timeTaken) {
        this.totalReadTime.incr(timeTaken);
    }

    public void addPacketAckRoundTripTimeNanos(long latencyNanos) {
        this.packetAckRoundTripTimeNanos.add(latencyNanos);
        for (MutableQuantiles q : this.packetAckRoundTripTimeNanosQuantiles) {
            q.add(latencyNanos);
        }
    }

    public void addFlushNanos(long latencyNanos) {
        this.flushNanos.add(latencyNanos);
        for (MutableQuantiles q : this.flushNanosQuantiles) {
            q.add(latencyNanos);
        }
    }

    public void addFsyncNanos(long latencyNanos) {
        this.fsyncNanos.add(latencyNanos);
        for (MutableQuantiles q : this.fsyncNanosQuantiles) {
            q.add(latencyNanos);
        }
    }

    public void shutdown() {
        DefaultMetricsSystem.shutdown();
    }

    public void incrWritesFromClient(boolean local, long size) {
        if (local) {
            this.writesFromLocalClient.incr();
        } else {
            this.writesFromRemoteClient.incr();
            this.remoteBytesWritten.incr(size);
        }
    }

    public void incrReadsFromClient(boolean local, long size) {
        if (local) {
            this.readsFromLocalClient.incr();
        } else {
            this.readsFromRemoteClient.incr();
            this.remoteBytesRead.incr(size);
        }
    }

    public void incrVolumeFailures() {
        this.volumeFailures.incr();
    }

    public void incrDatanodeNetworkErrors() {
        this.datanodeNetworkErrors.incr();
    }

    public void incrBlocksGetLocalPathInfo() {
        this.blocksGetLocalPathInfo.incr();
    }

    public void addSendDataPacketBlockedOnNetworkNanos(long latencyNanos) {
        this.sendDataPacketBlockedOnNetworkNanos.add(latencyNanos);
        for (MutableQuantiles q : this.sendDataPacketBlockedOnNetworkNanosQuantiles) {
            q.add(latencyNanos);
        }
    }

    public void addSendDataPacketTransferNanos(long latencyNanos) {
        this.sendDataPacketTransferNanos.add(latencyNanos);
        for (MutableQuantiles q : this.sendDataPacketTransferNanosQuantiles) {
            q.add(latencyNanos);
        }
    }

    public void incrRamDiskBlocksWrite() {
        this.ramDiskBlocksWrite.incr();
    }

    public void incrRamDiskBlocksWriteFallback() {
        this.ramDiskBlocksWriteFallback.incr();
    }

    public void addRamDiskBytesWrite(long bytes) {
        this.ramDiskBytesWrite.incr(bytes);
    }

    public void incrRamDiskBlocksReadHits() {
        this.ramDiskBlocksReadHits.incr();
    }

    public void incrRamDiskBlocksEvicted() {
        this.ramDiskBlocksEvicted.incr();
    }

    public void incrRamDiskBlocksEvictedWithoutRead() {
        this.ramDiskBlocksEvictedWithoutRead.incr();
    }

    public void addRamDiskBlocksEvictionWindowMs(long latencyMs) {
        this.ramDiskBlocksEvictionWindowMs.add(latencyMs);
        for (MutableQuantiles q : this.ramDiskBlocksEvictionWindowMsQuantiles) {
            q.add(latencyMs);
        }
    }

    public void incrRamDiskBlocksLazyPersisted() {
        this.ramDiskBlocksLazyPersisted.incr();
    }

    public void incrRamDiskBlocksDeletedBeforeLazyPersisted() {
        this.ramDiskBlocksDeletedBeforeLazyPersisted.incr();
    }

    public void incrRamDiskBytesLazyPersisted(long bytes) {
        this.ramDiskBytesLazyPersisted.incr(bytes);
    }

    public void addRamDiskBlocksLazyPersistWindowMs(long latencyMs) {
        this.ramDiskBlocksLazyPersistWindowMs.add(latencyMs);
        for (MutableQuantiles q : this.ramDiskBlocksLazyPersistWindowMsQuantiles) {
            q.add(latencyMs);
        }
    }
}

