/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.hadoop2.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;

@InterfaceAudience.Private
public class FsDatasetUtil {
    static boolean isUnlinkTmpFile(File f) {
        return f.getName().endsWith(".unlinked");
    }

    static File getOrigFile(File unlinkTmpFile) {
        String name = unlinkTmpFile.getName();
        if (!name.endsWith(".unlinked")) {
            throw new IllegalArgumentException("unlinkTmpFile=" + unlinkTmpFile + " does not end with " + ".unlinked");
        }
        int n = name.length() - ".unlinked".length();
        return new File(unlinkTmpFile.getParentFile(), name.substring(0, n));
    }

    static File getMetaFile(File f, long gs) {
        return new File(f.getParent(), DatanodeUtil.getMetaName(f.getName(), gs));
    }

    public static File findMetaFile(File blockFile) throws IOException {
        final String prefix = blockFile.getName() + "_";
        final File parent = blockFile.getParentFile();
        File[] matches = parent.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.equals(parent) && name.startsWith(prefix) && name.endsWith(".meta");
            }
        });
        if (matches == null || matches.length == 0) {
            throw new IOException("Meta file not found, blockFile=" + blockFile);
        }
        if (matches.length > 1) {
            throw new IOException("Found more than one meta files: " + Arrays.asList(matches));
        }
        return matches[0];
    }

    static long getGenerationStampFromFile(File[] listdir, File blockFile) {
        String blockName = blockFile.getName();
        for (int j = 0; j < listdir.length; ++j) {
            String path = listdir[j].getName();
            if (!path.startsWith(blockName) || blockFile == listdir[j]) continue;
            return Block.getGenerationStamp(listdir[j].getName());
        }
        FsDatasetImpl.LOG.warn((Object)("Block " + blockFile + " does not have a metafile!"));
        return 0L;
    }

    static long parseGenerationStamp(File blockFile, File metaFile) throws IOException {
        String metaname = metaFile.getName();
        String gs = metaname.substring(blockFile.getName().length() + 1, metaname.length() - ".meta".length());
        try {
            return Long.parseLong(gs);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Failed to parse generation stamp: blockFile=" + blockFile + ", metaFile=" + metaFile, nfe);
        }
    }

    public static void computeChecksum(File srcMeta, File dstMeta, File blockFile) throws IOException {
        Preconditions.checkNotNull(srcMeta);
        Preconditions.checkNotNull(dstMeta);
        Preconditions.checkNotNull(blockFile);
        FsDatasetImpl.computeChecksum(srcMeta, dstMeta, blockFile);
    }
}

