/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.dispatcher.ExecutionGraphInfoStore;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.messages.webmonitor.JobsOverview;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.shaded.guava30.com.google.common.base.Ticker;
import org.apache.flink.shaded.guava30.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava30.com.google.common.cache.CacheBuilder;
import org.apache.flink.util.ShutdownHookUtil;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryExecutionGraphInfoStore
implements ExecutionGraphInfoStore {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryExecutionGraphInfoStore.class);
    private final Cache<JobID, ExecutionGraphInfo> serializableExecutionGraphInfos;
    @Nullable
    private final ScheduledFuture<?> cleanupFuture;
    private final Thread shutdownHook;

    public MemoryExecutionGraphInfoStore() {
        this(Time.milliseconds((long)0L), 0, null, null);
    }

    public MemoryExecutionGraphInfoStore(Time expirationTime, int maximumCapacity, @Nullable ScheduledExecutor scheduledExecutor, @Nullable Ticker ticker) {
        long expirationMills = expirationTime.toMilliseconds();
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (expirationMills > 0L) {
            cacheBuilder.expireAfterWrite(expirationMills, TimeUnit.MILLISECONDS);
        }
        if (maximumCapacity > 0) {
            cacheBuilder.maximumSize((long)maximumCapacity);
        }
        if (ticker != null) {
            cacheBuilder.ticker(ticker);
        }
        this.serializableExecutionGraphInfos = cacheBuilder.build();
        this.cleanupFuture = scheduledExecutor != null ? scheduledExecutor.scheduleWithFixedDelay(() -> this.serializableExecutionGraphInfos.cleanUp(), expirationTime.toMilliseconds(), expirationTime.toMilliseconds(), TimeUnit.MILLISECONDS) : null;
        this.shutdownHook = ShutdownHookUtil.addShutdownHook((AutoCloseable)this, (String)this.getClass().getSimpleName(), (Logger)LOG);
    }

    @Override
    public int size() {
        return Math.toIntExact(this.serializableExecutionGraphInfos.size());
    }

    @Override
    @Nullable
    public ExecutionGraphInfo get(JobID jobId) {
        return (ExecutionGraphInfo)this.serializableExecutionGraphInfos.getIfPresent((Object)jobId);
    }

    @Override
    public void put(ExecutionGraphInfo serializableExecutionGraphInfo) throws IOException {
        this.serializableExecutionGraphInfos.put((Object)serializableExecutionGraphInfo.getJobId(), (Object)serializableExecutionGraphInfo);
    }

    @Override
    public JobsOverview getStoredJobsOverview() {
        Collection allJobStatus = this.serializableExecutionGraphInfos.asMap().values().stream().map(ExecutionGraphInfo::getArchivedExecutionGraph).map(ArchivedExecutionGraph::getState).collect(Collectors.toList());
        return JobsOverview.create(allJobStatus);
    }

    @Override
    public Collection<JobDetails> getAvailableJobDetails() {
        return this.serializableExecutionGraphInfos.asMap().values().stream().map(ExecutionGraphInfo::getArchivedExecutionGraph).map(JobDetails::createDetailsForJob).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public JobDetails getAvailableJobDetails(JobID jobId) {
        ExecutionGraphInfo archivedExecutionGraphInfo = (ExecutionGraphInfo)this.serializableExecutionGraphInfos.getIfPresent((Object)jobId);
        if (archivedExecutionGraphInfo != null) {
            return JobDetails.createDetailsForJob(archivedExecutionGraphInfo.getArchivedExecutionGraph());
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.cleanupFuture != null) {
            this.cleanupFuture.cancel(false);
        }
        this.serializableExecutionGraphInfos.invalidateAll();
        ShutdownHookUtil.removeShutdownHook((Thread)this.shutdownHook, (String)this.getClass().getSimpleName(), (Logger)LOG);
    }
}

