/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.client.deployment.application.ApplicationRunner;
import org.apache.flink.client.deployment.application.DetachedApplicationRunner;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.rest.handler.RestHandlerSpecification;
import org.apache.flink.runtime.webmonitor.WebMonitorExtension;
import org.apache.flink.runtime.webmonitor.handlers.JarDeleteHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarDeleteHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarListHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarListHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarPlanGetHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarPlanHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarPlanPostHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarRunHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarRunHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarUploadHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarUploadHeaders;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandler;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.apache.flink.util.concurrent.SeparateThreadExecutor;

public class WebSubmissionExtension
implements WebMonitorExtension {
    private final ArrayList<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> webSubmissionHandlers = new ArrayList();
    private final JarUploadHandler jarUploadHandler;
    private final JarRunHandler jarRunHandler;

    public WebSubmissionExtension(Configuration configuration, GatewayRetriever<? extends DispatcherGateway> leaderRetriever, Map<String, String> responseHeaders, CompletableFuture<String> localAddressFuture, Path jarDir, Executor executor, Time timeout) throws Exception {
        this(configuration, leaderRetriever, responseHeaders, localAddressFuture, jarDir, executor, timeout, () -> new DetachedApplicationRunner(true));
    }

    @VisibleForTesting
    WebSubmissionExtension(Configuration configuration, GatewayRetriever<? extends DispatcherGateway> leaderRetriever, Map<String, String> responseHeaders, CompletableFuture<String> localAddressFuture, Path jarDir, Executor executor, Time timeout, Supplier<ApplicationRunner> applicationRunnerSupplier) throws Exception {
        SeparateThreadExecutor jarRunExecutor = new SeparateThreadExecutor((ThreadFactory)new ExecutorThreadFactory.Builder().setPoolName("flink-jar-runner").build());
        this.jarUploadHandler = new JarUploadHandler(leaderRetriever, timeout, responseHeaders, JarUploadHeaders.getInstance(), jarDir, executor);
        JarListHandler jarListHandler = new JarListHandler(leaderRetriever, timeout, responseHeaders, JarListHeaders.getInstance(), localAddressFuture, jarDir.toFile(), configuration, executor);
        this.jarRunHandler = new JarRunHandler(leaderRetriever, timeout, responseHeaders, JarRunHeaders.getInstance(), jarDir, configuration, (Executor)jarRunExecutor, applicationRunnerSupplier);
        JarDeleteHandler jarDeleteHandler = new JarDeleteHandler(leaderRetriever, timeout, responseHeaders, JarDeleteHeaders.getInstance(), jarDir, executor);
        JarPlanHandler jarPlanHandler = new JarPlanHandler(leaderRetriever, timeout, responseHeaders, JarPlanGetHeaders.getInstance(), jarDir, configuration, (Executor)jarRunExecutor);
        JarPlanHandler postJarPlanHandler = new JarPlanHandler(leaderRetriever, timeout, responseHeaders, JarPlanPostHeaders.getInstance(), jarDir, configuration, executor);
        this.webSubmissionHandlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)JarUploadHeaders.getInstance(), (Object)((Object)this.jarUploadHandler)));
        this.webSubmissionHandlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)JarListHeaders.getInstance(), (Object)((Object)jarListHandler)));
        this.webSubmissionHandlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)JarRunHeaders.getInstance(), (Object)((Object)this.jarRunHandler)));
        this.webSubmissionHandlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)JarDeleteHeaders.getInstance(), (Object)((Object)jarDeleteHandler)));
        this.webSubmissionHandlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)JarPlanGetHeaders.getInstance(), (Object)((Object)jarPlanHandler)));
        this.webSubmissionHandlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)JarPlanPostHeaders.getInstance(), (Object)((Object)postJarPlanHandler)));
    }

    public CompletableFuture<Void> closeAsync() {
        return CompletableFuture.completedFuture(null);
    }

    public Collection<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> getHandlers() {
        return this.webSubmissionHandlers;
    }

    @VisibleForTesting
    JarUploadHandler getJarUploadHandler() {
        return this.jarUploadHandler;
    }

    @VisibleForTesting
    JarRunHandler getJarRunHandler() {
        return this.jarRunHandler;
    }
}

