/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.AuthInfo;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Cluster;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Config;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Context;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NamedAuthInfo;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NamedCluster;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NamedContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.Serialization;

public class KubeConfigUtils {
    private KubeConfigUtils() {
    }

    public static Config parseConfig(File file) throws IOException {
        return Serialization.unmarshal((InputStream)new FileInputStream(file), Config.class);
    }

    public static Config parseConfigFromString(String contents) {
        return Serialization.unmarshal(contents, Config.class);
    }

    public static NamedContext getCurrentContext(Config config) {
        List<NamedContext> contexts;
        String contextName = config.getCurrentContext();
        if (contextName != null && (contexts = config.getContexts()) != null) {
            for (NamedContext context : contexts) {
                if (!contextName.equals(context.getName())) continue;
                return context;
            }
        }
        return null;
    }

    public static String getUserToken(Config config, Context context) {
        AuthInfo authInfo = KubeConfigUtils.getUserAuthInfo(config, context);
        if (authInfo != null) {
            return authInfo.getToken();
        }
        return null;
    }

    public static AuthInfo getUserAuthInfo(Config config, Context context) {
        List<NamedAuthInfo> users;
        String user;
        AuthInfo authInfo = null;
        if (config != null && context != null && (user = context.getUser()) != null && (users = config.getUsers()) != null) {
            authInfo = users.stream().filter(u -> u.getName().equals(user)).findAny().map(NamedAuthInfo::getUser).orElse(null);
        }
        return authInfo;
    }

    public static Cluster getCluster(Config config, Context context) {
        List<NamedCluster> clusters;
        String clusterName;
        Cluster cluster = null;
        if (config != null && context != null && (clusterName = context.getCluster()) != null && (clusters = config.getClusters()) != null) {
            cluster = clusters.stream().filter(c -> c.getName().equals(clusterName)).findAny().map(NamedCluster::getCluster).orElse(null);
        }
        return cluster;
    }

    public static int getNamedUserIndexFromConfig(Config config, String userName) {
        for (int i = 0; i < config.getUsers().size(); ++i) {
            if (!config.getUsers().get(i).getName().equals(userName)) continue;
            return i;
        }
        return -1;
    }

    public static void persistKubeConfigIntoFile(Config kubeConfig, String kubeConfigPath) throws IOException {
        try (FileWriter writer = new FileWriter(kubeConfigPath);){
            writer.write(Serialization.asYaml(kubeConfig));
        }
    }
}

